/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.portlet.MimeResponse;
import javax.portlet.ResourceResponse;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang.CharUtils;

public class PortletResponseUtil {
    private static Log _log = LogFactoryUtil.getLog(PortletResponseUtil.class);

    public static void sendFile(MimeResponse mimeResponse, String fileName, byte[] bytes) throws IOException {
        PortletResponseUtil.sendFile(mimeResponse, fileName, bytes, null);
    }

    public static void sendFile(MimeResponse mimeResponse, String fileName, byte[] bytes, String contentType) throws IOException {
        PortletResponseUtil.setHeaders(mimeResponse, fileName, contentType);
        PortletResponseUtil.write(mimeResponse, bytes);
    }

    public static void sendFile(MimeResponse mimeResponse, String fileName, InputStream is) throws IOException {
        PortletResponseUtil.sendFile(mimeResponse, fileName, is, null);
    }

    public static void sendFile(MimeResponse mimeResponse, String fileName, InputStream is, String contentType) throws IOException {
        PortletResponseUtil.sendFile(mimeResponse, fileName, is, 0, contentType);
    }

    public static void sendFile(MimeResponse mimeResponse, String fileName, InputStream is, int contentLength, String contentType) throws IOException {
        PortletResponseUtil.setHeaders(mimeResponse, fileName, contentType);
        PortletResponseUtil.write(mimeResponse, is, contentLength);
    }

    public static void write(MimeResponse mimeResponse, String s) throws IOException {
        PortletResponseUtil.write(mimeResponse, s.getBytes("UTF-8"));
    }

    public static void write(MimeResponse mimeResponse, byte[] bytes) throws IOException {
        PortletResponseUtil.write(mimeResponse, bytes, 0);
    }

    public static void write(MimeResponse mimeResponse, byte[] bytes, int contentLength) throws IOException {
        if (!mimeResponse.isCommitted()) {
            if (contentLength == 0) {
                contentLength = bytes.length;
            }
            if (mimeResponse instanceof ResourceResponse) {
                ResourceResponse resourceResponse = (ResourceResponse)mimeResponse;
                resourceResponse.setContentLength(contentLength);
            }
            OutputStream outputStream = mimeResponse.getPortletOutputStream();
            outputStream.write(bytes, 0, contentLength);
        }
    }

    public static void write(MimeResponse mimeResponse, InputStream is) throws IOException {
        PortletResponseUtil.write(mimeResponse, is, 0);
    }

    public static void write(MimeResponse mimeResponse, InputStream is, int contentLength) throws IOException {
        if (mimeResponse.isCommitted()) {
            return;
        }
        if (contentLength > 0 && mimeResponse instanceof ResourceResponse) {
            ResourceResponse resourceResponse = (ResourceResponse)mimeResponse;
            resourceResponse.setContentLength(contentLength);
        }
        StreamUtil.transfer((InputStream)is, (OutputStream)mimeResponse.getPortletOutputStream());
    }

    protected static void setHeaders(MimeResponse mimeResponse, String fileName, String contentType) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Sending file of type " + contentType));
        }
        if (Validator.isNotNull((String)contentType)) {
            mimeResponse.setContentType(contentType);
        }
        mimeResponse.setProperty("Cache-Control", "public");
        mimeResponse.setProperty("Pragma", "public");
        if (Validator.isNotNull((String)fileName)) {
            String contentDisposition;
            block10: {
                contentDisposition = "attachment; filename=\"" + fileName + "\"";
                boolean ascii = true;
                for (int i = 0; i < fileName.length(); ++i) {
                    if (CharUtils.isAscii((char)fileName.charAt(i))) continue;
                    ascii = false;
                    break;
                }
                try {
                    if (!ascii) {
                        URLCodec codec = new URLCodec("UTF-8");
                        String encodedFileName = StringUtil.replace((String)codec.encode(fileName), (String)"+", (String)"%20");
                        contentDisposition = "attachment; filename*=UTF-8''" + encodedFileName;
                    }
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block10;
                    _log.warn((Throwable)e);
                }
            }
            String extension = GetterUtil.getString((String)FileUtil.getExtension((String)fileName)).toLowerCase();
            Object[] mimeTypesContentDispositionInline = null;
            try {
                mimeTypesContentDispositionInline = PropsUtil.getArray((String)"mime.types.content.disposition.inline");
            }
            catch (Exception e) {
                mimeTypesContentDispositionInline = new String[]{};
            }
            if (ArrayUtil.contains((Object[])mimeTypesContentDispositionInline, (Object)extension)) {
                contentDisposition = StringUtil.replace((String)contentDisposition, (String)"attachment; ", (String)"inline; ");
            }
            mimeResponse.setProperty("Content-Disposition", contentDisposition);
        }
    }
}

