/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.servlet.filters;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.util.servlet.Header;
import com.liferay.util.servlet.filters.CacheResponseStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheResponse
extends HttpServletResponseWrapper {
    private int _bufferSize;
    private String _contentType;
    private String _encoding;
    private Map<String, List<Header>> _headers = new HashMap<String, List<Header>>();
    private int _status = 200;
    private CacheResponseStream _stream;
    private UnsyncByteArrayOutputStream _ubaos = new UnsyncByteArrayOutputStream();
    private PrintWriter _writer;

    public CacheResponse(HttpServletResponse response, String encoding) {
        super(response);
        this._encoding = encoding;
    }

    public void addDateHeader(String name, long value) {
        List<Header> values = this._headers.get(name);
        if (values == null) {
            values = new ArrayList<Header>();
            this._headers.put(name, values);
        }
        Header header = new Header();
        header.setType(2);
        header.setDateValue(value);
        values.add(header);
    }

    public void addHeader(String name, String value) {
        List<Header> values = this._headers.get(name);
        if (values == null) {
            values = new ArrayList<Header>();
            this._headers.put(name, values);
        }
        Header header = new Header();
        header.setType(3);
        header.setStringValue(value);
        values.add(header);
        if (name.equals("Content-Type")) {
            this.setContentType(value);
        }
    }

    public void addIntHeader(String name, int value) {
        List<Header> values = this._headers.get(name);
        if (values == null) {
            values = new ArrayList<Header>();
            this._headers.put(name, values);
        }
        Header header = new Header();
        header.setType(1);
        header.setIntValue(value);
        values.add(header);
    }

    public void finishResponse() {
        try {
            if (this._writer != null) {
                this._writer.close();
            } else if (this._stream != null) {
                this._stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flushBuffer() throws IOException {
        if (this._stream != null) {
            this._stream.flush();
        }
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public String getContentType() {
        return this._contentType;
    }

    public byte[] getData() {
        this.finishResponse();
        return this._ubaos.toByteArray();
    }

    public String getHeader(String name) {
        List<Header> values = this._headers.get(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        Header header = values.get(0);
        return header.toString();
    }

    public Map<String, List<Header>> getHeaders() {
        return this._headers;
    }

    public ServletOutputStream getOutputStream() {
        if (this._writer != null) {
            throw new IllegalStateException();
        }
        if (this._stream == null) {
            this._stream = this.createOutputStream();
        }
        return this._stream;
    }

    public int getStatus() {
        return this._status;
    }

    public PrintWriter getWriter() throws IOException {
        if (this._writer != null) {
            return this._writer;
        }
        if (this._stream != null) {
            throw new IllegalStateException();
        }
        this._stream = this.createOutputStream();
        this._writer = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this._stream), this._encoding));
        return this._writer;
    }

    public boolean isCommitted() {
        if (this._writer != null) {
            return true;
        }
        if (this._stream != null && this._stream.isClosed()) {
            return true;
        }
        return super.isCommitted();
    }

    public void sendError(int status) throws IOException {
        this._status = status;
        super.sendError(status);
    }

    public void sendError(int status, String msg) throws IOException {
        this._status = status;
        super.sendError(status, msg);
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public void setContentType(String contentType) {
        this._contentType = contentType;
        super.setContentType(contentType);
    }

    public void setDateHeader(String name, long value) {
        ArrayList<Header> values = new ArrayList<Header>();
        this._headers.put(name, values);
        Header header = new Header();
        header.setType(2);
        header.setDateValue(value);
        values.add(header);
    }

    public void setHeader(String name, String value) {
        ArrayList<Header> values = new ArrayList<Header>();
        this._headers.put(name, values);
        Header header = new Header();
        header.setType(3);
        header.setStringValue(value);
        values.add(header);
        if (name.equals("Content-Type")) {
            this.setContentType(value);
        }
    }

    public void setIntHeader(String name, int value) {
        ArrayList<Header> values = new ArrayList<Header>();
        this._headers.put(name, values);
        Header header = new Header();
        header.setType(1);
        header.setIntValue(value);
        values.add(header);
    }

    public void setStatus(int status) {
        this._status = status;
        super.setStatus(status);
    }

    protected CacheResponseStream createOutputStream() {
        return new CacheResponseStream((OutputStream)this._ubaos);
    }
}

