/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.transport;

import com.liferay.util.transport.MulticastDatagramHandler;
import com.liferay.util.transport.MulticastTransport;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MulticastClientTool {
    public static void main(String[] args) {
        try {
            new MulticastClientTool(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            StringBuilder sb = new StringBuilder();
            sb.append("Usage: java -classpath ");
            sb.append("commons-logging.jar:util-java.jar ");
            sb.append("com.liferay.util.transport.MulticastClientTool [-g] ");
            sb.append("[-s] -h [multicastAddress] -p [port]");
            System.err.println(sb.toString());
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MulticastClientTool(String[] args) throws Exception {
        Map<String, Object> argsMap = this._getArgsMap(args);
        Integer port = (Integer)argsMap.get("port");
        String host = (String)argsMap.get("host");
        Boolean gzipData = (Boolean)argsMap.get("gzip");
        Boolean shortData = (Boolean)argsMap.get("short");
        MulticastDatagramHandler handler = new MulticastDatagramHandler(gzipData, shortData);
        MulticastTransport transport = new MulticastTransport(handler, host, port);
        if (shortData.booleanValue()) {
            System.out.println("Truncating to 96 bytes.");
        }
        System.out.println("Started up and waiting...");
        transport.connect();
        MulticastTransport multicastTransport = transport;
        synchronized (multicastTransport) {
            transport.wait();
        }
    }

    private Map<String, Object> _getArgsMap(String[] args) throws Exception {
        HashMap<String, Object> argsMap = new HashMap<String, Object>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-g")) {
                argsMap.put("gzip", Boolean.TRUE);
                continue;
            }
            if (args[i].equals("-s")) {
                argsMap.put("short", Boolean.TRUE);
                continue;
            }
            if (args[i].equals("-h")) {
                argsMap.put("host", args[i + 1]);
                ++i;
                continue;
            }
            if (!args[i].equals("-p")) continue;
            argsMap.put("port", new Integer(args[i + 1]));
            ++i;
        }
        if (!argsMap.containsKey("gzip")) {
            argsMap.put("gzip", Boolean.FALSE);
        }
        if (!argsMap.containsKey("short")) {
            argsMap.put("short", Boolean.FALSE);
        }
        return argsMap;
    }
}

