/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.xml;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.util.TextFormatter;
import com.liferay.util.xml.DocUtil;
import java.lang.reflect.Method;
import java.util.List;

public class BeanToXMLUtil {
    private static Log _log = LogFactoryUtil.getLog(BeanToXMLUtil.class);

    public static void addBean(Object obj, Element parentEl) {
        String classNameWithoutPackage = BeanToXMLUtil.getClassNameWithoutPackage(obj.getClass().getName());
        Element el = parentEl.addElement(classNameWithoutPackage);
        BeanToXMLUtil.addFields(obj, el);
    }

    public static void addBean(Object obj, org.dom4j.Element parentEl) {
        String classNameWithoutPackage = BeanToXMLUtil.getClassNameWithoutPackage(obj.getClass().getName());
        org.dom4j.Element el = parentEl.addElement(classNameWithoutPackage);
        BeanToXMLUtil.addFields(obj, el);
    }

    public static void addFields(Object obj, Element parentEl) {
        Method[] methods = obj.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().startsWith("get") || method.getName().equals("getClass")) continue;
            String memberName = StringUtil.replace((String)method.getName(), (String)"get", (String)"");
            memberName = TextFormatter.format(memberName, 8);
            memberName = TextFormatter.format(memberName, 10);
            try {
                Object returnValue = method.invoke(obj, new Object[0]);
                if (returnValue instanceof List) {
                    List list = (List)returnValue;
                    Element listEl = parentEl.addElement(memberName);
                    for (int j = 0; j < list.size(); ++j) {
                        BeanToXMLUtil.addBean(list.get(j), listEl);
                    }
                    continue;
                }
                DocUtil.add(parentEl, memberName, returnValue.toString());
                continue;
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)e.getMessage());
            }
        }
    }

    public static void addFields(Object obj, org.dom4j.Element parentEl) {
        Method[] methods = obj.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().startsWith("get") || method.getName().equals("getClass")) continue;
            String memberName = StringUtil.replace((String)method.getName(), (String)"get", (String)"");
            memberName = TextFormatter.format(memberName, 8);
            memberName = TextFormatter.format(memberName, 10);
            try {
                Object returnValue = method.invoke(obj, new Object[0]);
                if (returnValue instanceof List) {
                    List list = (List)returnValue;
                    org.dom4j.Element listEl = parentEl.addElement(memberName);
                    for (int j = 0; j < list.size(); ++j) {
                        BeanToXMLUtil.addBean(list.get(j), listEl);
                    }
                    continue;
                }
                DocUtil.add(parentEl, memberName, returnValue.toString());
                continue;
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)e.getMessage());
            }
        }
    }

    public static String getClassNameWithoutPackage(String className) {
        String[] classNameArray = StringUtil.split((String)className, (String)".");
        String classNameWithoutPackage = classNameArray[classNameArray.length - 1];
        classNameWithoutPackage = TextFormatter.format(classNameWithoutPackage, 8);
        classNameWithoutPackage = TextFormatter.format(classNameWithoutPackage, 10);
        return classNameWithoutPackage;
    }
}

