/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.xml;

import com.liferay.util.xml.ElementComparator;
import com.liferay.util.xml.XMLElementComparator;
import com.liferay.util.xml.descriptor.XMLDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLMerger {
    private XMLDescriptor _descriptor;

    public XMLMerger(XMLDescriptor descriptor) {
        this._descriptor = descriptor;
    }

    public XMLElementComparator getElementComparator() {
        return new XMLElementComparator(this._descriptor);
    }

    public Document merge(Document masterDoc, Document slaveDoc) {
        Document mergedDoc = (Document)masterDoc.clone();
        Element root1 = mergedDoc.getRootElement();
        Element root2 = slaveDoc.getRootElement();
        List children = root2.elements();
        for (Element el2 : children) {
            Element el2Clone = (Element)el2.clone();
            el2Clone.detach();
            root1.add(el2Clone);
        }
        this.organizeXML(mergedDoc);
        return mergedDoc;
    }

    public void organizeXML(Document doc) {
        Element root = doc.getRootElement();
        this._orderChildren(root, this._descriptor.getRootChildrenOrder());
        this._mergeDuplicateElements(root, this.getElementComparator());
    }

    private void _addChildren(Element first, Collection<Element> childrenToJoin) {
        Vector<Element> clones = new Vector<Element>();
        Iterator<Element> itr = childrenToJoin.iterator();
        while (itr.hasNext()) {
            clones.add((Element)itr.next().clone());
        }
        first.elements().addAll(clones);
        this._orderChildren(first, this._descriptor.getChildrenOrder(first));
    }

    private boolean _containsObjectEqualTo(Element example, List<Element> list, ElementComparator comparator) {
        for (Element candidate : list) {
            if (comparator.compare(example, candidate) != 0) continue;
            return true;
        }
        return false;
    }

    private Element _findObjectEqualTo(Element example, List<Element> list, ElementComparator comparator) {
        for (Element candidate : list) {
            if (comparator.compare(example, candidate) != 0) continue;
            return candidate;
        }
        return example;
    }

    private void _mergeDuplicateElements(Element el, ElementComparator comparator) {
        if (el.elements().size() > 0) {
            List children = el.elements();
            ArrayList<Element> originals = new ArrayList<Element>();
            ArrayList<Element> duplicates = new ArrayList<Element>();
            for (int i = 0; i < children.size(); ++i) {
                Element child = (Element)children.get(i);
                if (this._containsObjectEqualTo(child, originals, comparator)) {
                    if (this._descriptor.canJoinChildren(child)) {
                        Element first = this._findObjectEqualTo(child, originals, comparator);
                        List childrenToJoin = child.elements();
                        this._addChildren(first, childrenToJoin);
                    }
                    duplicates.add(child);
                    continue;
                }
                originals.add(child);
            }
            for (Element duplicate : duplicates) {
                duplicate.detach();
            }
            for (Element child : originals) {
                this._mergeDuplicateElements(child, comparator);
            }
        }
    }

    private void _orderChildren(Element parent, String[] orderedChildrenNames) {
        if (orderedChildrenNames == null) {
            return;
        }
        ArrayList elements = new ArrayList();
        for (int i = 0; i < orderedChildrenNames.length; ++i) {
            elements.addAll(parent.elements(orderedChildrenNames[i]));
        }
        for (Element el : elements) {
            el.detach();
            parent.add(el);
        }
    }
}

