/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.application;

import com.icesoft.faces.application.ProductInfo;
import com.icesoft.faces.component.NamespacingViewRoot;
import com.icesoft.faces.context.BridgeExternalContext;
import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.webapp.http.servlet.ServletExternalContext;
import com.icesoft.faces.webapp.parser.ImplementationUtil;
import com.icesoft.faces.webapp.parser.JspPageToDocument;
import com.icesoft.faces.webapp.parser.Parser;
import com.icesoft.util.SeamUtilities;
import java.beans.Beans;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class D2DViewHandler
extends ViewHandler {
    protected static Log log = LogFactory.getLog((Class)D2DViewHandler.class);
    private static final String DELEGATE_NONIFACE = "com.icesoft.faces.delegateNonIface";
    private static final String ACTION_URL_SUFFIX = "com.icesoft.faces.actionURLSuffix";
    private static final String RELOAD_INTERVAL = "com.icesoft.faces.reloadInterval";
    private static final String DO_JSF_STATE_MANAGEMENT = "com.icesoft.faces.doJSFStateManagement";
    public static final String INCLUDE_OPEN_AJAX_HUB = "com.icesoft.faces.openAjaxHub";
    private static final String LAST_LOADED_KEY = "_lastLoaded";
    private static final String LAST_CHECKED_KEY = "_lastChecked";
    public static final String DOM_CONTEXT_TABLE = "com.icesoft.faces.sessionAuxiliaryData";
    public static final String CHAR_ENCODING = "UTF-8";
    public static final String HTML_CONTENT_TYPE = "text/html;charset=UTF-8";
    public static final String DEFAULT_VIEW_ID = "default";
    private String actionURLSuffix;
    protected boolean delegateNonIface = false;
    protected boolean delegateNonIfaceDefault = false;
    protected boolean jsfStateManagement;
    protected long reloadInterval;
    protected long reloadIntervalDefault = 2L;
    private boolean parametersInitialized = false;
    protected Parser parser;
    private ViewHandler delegate;

    public D2DViewHandler() {
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("serializedTagToComponentMapFull.ser");
            this.parser = new Parser(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public D2DViewHandler(ViewHandler delegate) {
        this();
        this.delegate = delegate;
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        this.initializeParameters(context);
        if (this.delegateView(viewToRender.getViewId())) {
            this.delegate.renderView(context, viewToRender);
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("renderView(FC,UIVR)  BEFORE  renderResponse  viewToRender.getViewId(): " + viewToRender.getViewId()));
        }
        this.renderResponse(context);
        if (this.jsfStateManagement) {
            StateManager stateMgr = context.getApplication().getStateManager();
            stateMgr.saveSerializedView(context);
        }
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        this.initializeParameters(context);
        if (this.delegateView(viewId)) {
            return this.delegate.createView(context, viewId);
        }
        NamespacingViewRoot root = new NamespacingViewRoot(context);
        root.setRenderKitId("HTML_BASIC");
        Map contextServletTable = D2DViewHandler.getContextServletTable(context);
        if (null == viewId) {
            root.setViewId(DEFAULT_VIEW_ID);
            context.setViewRoot((UIViewRoot)root);
            contextServletTable.put("com.icesoft.domResponseViewRoot", root);
            Locale locale = this.calculateLocale(context);
            root.setLocale(locale);
            return root;
        }
        root.setViewId(viewId);
        context.setViewRoot((UIViewRoot)root);
        contextServletTable.put("com.icesoft.domResponseViewRoot", root);
        return root;
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        this.initializeParameters(context);
        if (this.delegateView(viewId)) {
            return this.delegate.restoreView(context, viewId);
        }
        UIViewRoot currentRoot = context.getViewRoot();
        ExternalContext externalContext = context.getExternalContext();
        if (externalContext instanceof ServletExternalContext) {
            ServletExternalContext servletExternalContext = (ServletExternalContext)externalContext;
            servletExternalContext.setRequestServletPath(viewId);
            if (null != externalContext.getRequestPathInfo()) {
                servletExternalContext.setRequestPathInfo(viewId);
            }
            if (SeamUtilities.isSeamEnvironment()) {
                if (servletExternalContext.getRequestParameterMap().remove("com.icesoft.faces.shortcutLifecycle") != null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Seam Keyword shortcut found, new ViewRoot");
                    }
                    return null;
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)"No Seam Keyword shortcut found");
                }
            }
        }
        if (null != currentRoot && D2DViewHandler.mungeViewId(viewId).equals(D2DViewHandler.mungeViewId(currentRoot.getViewId()))) {
            return currentRoot;
        }
        Map contextServletTable = D2DViewHandler.getContextServletTable(context);
        if (contextServletTable.containsKey("com.icesoft.domResponseContexts")) {
            Map domResponseContexts = (Map)contextServletTable.get("com.icesoft.domResponseContexts");
        } else {
            HashMap domResponseContexts = new HashMap();
            contextServletTable.put("com.icesoft.domResponseContexts", domResponseContexts);
        }
        UIViewRoot root = null;
        root = (UIViewRoot)contextServletTable.get("com.icesoft.domResponseViewRoot");
        if (null == root || null == viewId || D2DViewHandler.mungeViewId(viewId).equals(D2DViewHandler.mungeViewId(root.getViewId()))) {
            // empty if block
        }
        return root;
    }

    private static Map getContextServletTables(FacesContext context) {
        Map contextTable;
        String treeKey;
        Map sessionMap = context.getExternalContext().getSessionMap();
        String viewNumber = "-";
        if (context instanceof BridgeFacesContext) {
            viewNumber = ((BridgeFacesContext)context).getViewNumber();
        }
        if (sessionMap.containsKey(treeKey = viewNumber + "/" + DOM_CONTEXT_TABLE)) {
            contextTable = (Map)sessionMap.get(treeKey);
        } else {
            contextTable = new HashMap();
            sessionMap.put(treeKey, contextTable);
        }
        return contextTable;
    }

    public static Map getContextServletTable(FacesContext context) {
        String servletRequestPath;
        Map domContextTables = D2DViewHandler.getContextServletTables(context);
        if (domContextTables.containsKey(servletRequestPath = D2DViewHandler.getServletRequestPath(context))) {
            return (Map)domContextTables.get(servletRequestPath);
        }
        HashMap domContextTable = new HashMap();
        domContextTables.put(servletRequestPath, domContextTable);
        return domContextTable;
    }

    public static String getServletRequestPath(FacesContext context) {
        if (Beans.isDesignTime()) {
            return context.getViewRoot().getViewId();
        }
        ExternalContext externalContext = context.getExternalContext();
        if (externalContext instanceof BridgeExternalContext) {
            String uri = ((BridgeExternalContext)externalContext).getRequestURI();
            if (null == uri) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Failing over to default request path");
                }
                uri = DEFAULT_VIEW_ID;
            }
            return uri;
        }
        return externalContext.getRequestContextPath() + externalContext.getRequestServletPath();
    }

    public static String getServletRequestPath(ExternalContext externalContext, String viewId) {
        if (externalContext == null) {
            throw new IllegalStateException("ExternalContext is null");
        }
        return externalContext.getRequestContextPath() + viewId;
    }

    public String getActionURL(FacesContext context, String viewId) {
        if (this.delegateView(viewId)) {
            return this.delegate.getActionURL(context, viewId);
        }
        if (viewId.indexOf("://") >= 0) {
            return viewId;
        }
        if (viewId.charAt(0) != '/') {
            throw new IllegalArgumentException("viewId " + viewId + "does not begin with '/'");
        }
        if (null != this.actionURLSuffix) {
            viewId = viewId.substring(0, viewId.lastIndexOf(".")) + this.actionURLSuffix;
        }
        return context.getExternalContext().getRequestContextPath() + viewId;
    }

    public String getResourceURL(FacesContext context, String path) {
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        if (path == null) {
            throw new NullPointerException("path cannot be null");
        }
        path = this.encode(path);
        ExternalContext extCtxt = context.getExternalContext();
        if (this.isPortlet(extCtxt)) {
            path = this.resolveFully(extCtxt, path);
        } else if (path.startsWith("/")) {
            StringBuffer dir = new StringBuffer();
            int atoms = extCtxt.getRequestServletPath().split("/").length;
            while (atoms-- > 2) {
                dir.append("../");
            }
            path = URI.create(dir + "." + path).normalize().toString();
        }
        return path;
    }

    private String encode(String path) {
        return path.trim().replaceAll(" ", "%20");
    }

    private boolean isPortlet(ExternalContext extCtxt) {
        return extCtxt.getRequestMap().get("com.icesoft.faces.PORTLET") != null;
    }

    private String resolveFully(ExternalContext extCtxt, String resource) {
        String context = extCtxt.getRequestContextPath();
        if (resource.startsWith("/")) {
            return context + resource;
        }
        String base = context + extCtxt.getRequestServletPath();
        try {
            URI baseURI = new URI(base);
            URI resourceURI = new URI(resource);
            URI resolvedURI = baseURI.resolve(resourceURI);
            return resolvedURI.toString();
        }
        catch (URISyntaxException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("could not resolve URI's based on\n  context : " + extCtxt.getRequestContextPath() + "\n  path    : " + extCtxt.getRequestServletPath() + "\n  resource: " + resource), (Throwable)e);
            }
            return resource;
        }
    }

    protected long getTimeAttribute(UIComponent root, String key) {
        Long timeLong = (Long)root.getAttributes().get(key);
        long time = null == timeLong ? 0L : timeLong;
        return time;
    }

    protected void renderResponse(FacesContext facesContext) throws IOException {
        BridgeFacesContext context = (BridgeFacesContext)facesContext;
        UIViewRoot root = context.getViewRoot();
        String viewId = root.getViewId();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Rendering " + root + " with " + root.getChildCount() + " children"));
        }
        this.clearSession(context);
        ResponseWriter responseWriter = context.createAndSetResponseWriter();
        boolean reloadView = false;
        URLConnection viewConnection = null;
        if (root.getChildCount() == 0 || this.reloadInterval > -1L) {
            if (viewId.startsWith("/faces")) {
                viewId = viewId.substring(6);
            }
            if (viewId.endsWith(".jpg") || viewId.endsWith(".gif") || viewId.endsWith(".png")) {
                context.getExternalContext().dispatch(viewId);
                return;
            }
            try {
                URL viewURL = context.getExternalContext().getResource(viewId);
                if (null == viewURL) {
                    if (viewId.endsWith(".faces")) {
                        viewId = D2DViewHandler.truncate(".faces", viewId);
                    } else if (viewId.endsWith(".jsf")) {
                        viewId = D2DViewHandler.truncate(".jsf", viewId);
                    } else if (viewId.endsWith(".iface")) {
                        viewId = D2DViewHandler.truncate(".iface", viewId);
                    } else if (viewId.endsWith(".jsp")) {
                        viewId = D2DViewHandler.truncate(".jsp", viewId);
                    }
                    viewId = viewId + ".jspx";
                    viewURL = context.getExternalContext().getResource(viewId);
                }
                if (null == viewURL) {
                    if (viewId.endsWith(".jspx")) {
                        viewId = D2DViewHandler.truncate(".jspx", viewId) + ".jsp";
                    }
                    viewURL = context.getExternalContext().getResource(viewId);
                }
                long currentTime = System.currentTimeMillis();
                long lastLoaded = this.getTimeAttribute((UIComponent)root, LAST_LOADED_KEY);
                long lastChecked = this.getTimeAttribute((UIComponent)root, LAST_CHECKED_KEY);
                long lastModified = 0L;
                if (currentTime > lastChecked + this.reloadInterval) {
                    viewConnection = viewURL.openConnection();
                    lastModified = viewConnection.getLastModified();
                    root.getAttributes().put(LAST_CHECKED_KEY, new Long(currentTime));
                    if (lastModified > lastLoaded) {
                        reloadView = true;
                    }
                }
            }
            catch (Exception e) {
                throw new FacesException("Can't find stream for " + viewId, (Throwable)e);
            }
        }
        if (reloadView) {
            Reader viewInput = null;
            try {
                viewInput = new InputStreamReader(viewConnection.getInputStream(), CHAR_ENCODING);
                if (viewId.endsWith(".jsp")) {
                    viewInput = JspPageToDocument.transform(viewInput);
                } else if (viewId.endsWith(".jspx")) {
                    viewInput = JspPageToDocument.preprocessJspDocument(viewInput);
                }
            }
            catch (Throwable e) {
                throw new FacesException("Can't read stream for " + viewId, e);
            }
            try {
                this.parser.parse(viewInput, context);
                root.getAttributes().put(LAST_LOADED_KEY, new Long(System.currentTimeMillis()));
            }
            catch (Throwable e) {
                throw new FacesException("Can't parse stream for " + viewId + " " + e.getMessage(), e);
            }
            if (ImplementationUtil.isJSF12()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Rendering outside ViewTag for JSF 1.2");
                }
                responseWriter.startDocument();
                this.renderResponse(context, (UIComponent)root);
                responseWriter.endDocument();
            }
        } else {
            responseWriter.startDocument();
            this.renderResponse(context, (UIComponent)root);
            responseWriter.endDocument();
            this.tracePrintComponentTree(context);
        }
    }

    protected void renderResponse(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        boolean isUIViewRoot = component instanceof UIViewRoot;
        if (!isUIViewRoot) {
            component.encodeBegin(context);
        }
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            Iterator kids = component.getChildren().iterator();
            while (kids.hasNext()) {
                this.renderResponse(context, (UIComponent)kids.next());
            }
        }
        if (!isUIViewRoot) {
            component.encodeEnd(context);
        }
        if (component instanceof UIData) {
            UIComponent stateHolder = component;
            stateHolder.restoreState(context, stateHolder.saveState(context));
        }
    }

    protected void tracePrintComponentTree(FacesContext context) {
        this.tracePrintComponentTree(context, (UIComponent)context.getViewRoot());
    }

    protected void tracePrintComponentTree(FacesContext context, UIComponent component) {
        if (log.isTraceEnabled()) {
            StringBuffer sb = new StringBuffer(4096);
            sb.append("tracePrintComponentTree() vvvvvv\n");
            this.tracePrintComponentTree(context, component, 0, sb, null);
            log.trace((Object)sb.toString());
            log.trace((Object)"tracePrintComponentTree() ^^^^^^");
        }
    }

    private void tracePrintComponentTree(FacesContext context, UIComponent component, int levels, StringBuffer sb, String facetName) {
        if (component == null) {
            sb.append("null\n");
            return;
        }
        String PREFIX_WHITESPACE = "  ";
        StringBuffer prefix = new StringBuffer(64);
        for (int i = 0; i < levels; ++i) {
            prefix.append("  ");
        }
        prefix.append("<");
        String compStr = component.toString();
        StringBuffer open = new StringBuffer(512);
        open.append(prefix);
        open.append(compStr);
        Map facetsMap = component.getFacets();
        boolean hasKids = component.getChildCount() > 0;
        boolean hasFacets = facetsMap != null && facetsMap.size() > 0;
        boolean hasUnderlings = hasKids | hasFacets;
        if (!hasUnderlings) {
            open.append("/");
        }
        open.append(">");
        if (facetName != null) {
            open.append(" facetName: ");
            open.append(facetName);
        }
        open.append(" id: ");
        open.append(component.getId());
        if (component.getParent() != null) {
            open.append(" clientId: ");
            open.append(component.getClientId(context));
        }
        if (hasKids) {
            open.append(" kids: ");
            open.append(Integer.toString(component.getChildCount()));
        }
        if (hasFacets) {
            open.append(" facets: ");
            open.append(Integer.toString(facetsMap.size()));
        }
        if (component.isTransient()) {
            open.append(" TRANSIENT ");
        }
        sb.append(open.toString());
        sb.append('\n');
        if (hasUnderlings) {
            if (hasFacets) {
                Object[] facetKeys = facetsMap.keySet().toArray();
                Arrays.sort(facetKeys);
                for (int i = 0; i < facetKeys.length; ++i) {
                    this.tracePrintComponentTree(context, (UIComponent)facetsMap.get(facetKeys[i]), levels + 1, sb, facetKeys[i].toString());
                }
            }
            if (hasKids) {
                Iterator kids = component.getChildren().iterator();
                while (kids.hasNext()) {
                    this.tracePrintComponentTree(context, (UIComponent)kids.next(), levels + 1, sb, null);
                }
            }
            StringBuffer close = new StringBuffer(512);
            close.append(prefix);
            close.append("/");
            close.append(compStr);
            close.append(">");
            sb.append(close);
            sb.append('\n');
        }
    }

    protected void clearSession(FacesContext context) {
        Map contextServletTable = D2DViewHandler.getContextServletTable(context);
        contextServletTable.remove("com.icesoft.domResponseContexts");
        contextServletTable.remove("com.icesoft.domResponseViewRoot");
        contextServletTable.remove("com.icesoft.domResponseDocument");
    }

    public void writeState(FacesContext context) throws IOException {
        if (this.delegateView(context.getViewRoot().getViewId())) {
            this.delegate.writeState(context);
        }
    }

    public Locale calculateLocale(FacesContext context) {
        Iterator locales = context.getExternalContext().getRequestLocales();
        while (locales.hasNext()) {
            Locale locale = (Locale)locales.next();
            Iterator supportedLocales = context.getApplication().getSupportedLocales();
            while (supportedLocales.hasNext()) {
                Locale supportedLocale = (Locale)supportedLocales.next();
                if (!locale.getLanguage().equals(supportedLocale.getLanguage())) continue;
                if (null == supportedLocale.getCountry() || "".equals(supportedLocale.getCountry())) {
                    return supportedLocale;
                }
                if (!locale.equals(supportedLocale)) continue;
                return supportedLocale;
            }
        }
        Locale defaultLocale = context.getApplication().getDefaultLocale();
        return null == defaultLocale ? Locale.getDefault() : defaultLocale;
    }

    public String calculateRenderKitId(FacesContext context) {
        return this.delegate.calculateRenderKitId(context);
    }

    public static boolean isValueReference(String value) {
        return value.indexOf("#{") != -1 && value.indexOf("#{") < value.indexOf(125);
    }

    public static UIComponent findComponent(String clientId, UIComponent base) {
        String delimeter = String.valueOf(':');
        if (clientId.startsWith(delimeter)) {
            while (base.getParent() != null) {
                base = base.getParent();
            }
            clientId = clientId.substring(1);
        } else {
            while (base.getParent() != null && !(base instanceof NamingContainer)) {
                base = base.getParent();
            }
        }
        String id = null;
        UIComponent result = null;
        while (clientId.length() > 0) {
            int separator = clientId.indexOf(58);
            if (base instanceof UIData) {
                if (separator >= 0) {
                    clientId = clientId.substring(separator + 1);
                }
                separator = clientId.indexOf(58);
            }
            if (separator >= 0) {
                id = clientId.substring(0, separator);
                clientId = clientId.substring(separator + 1);
            } else {
                id = clientId;
                clientId = "";
            }
            result = D2DViewHandler.findComponent(base, id);
            if (result == null || clientId.length() == 0) break;
            if (!(result instanceof NamingContainer)) continue;
            result = D2DViewHandler.findComponent(clientId, result);
            break;
        }
        return result;
    }

    private static String truncate(String remove, String input) {
        return input.substring(0, input.length() - remove.length());
    }

    private boolean delegateView(String viewId) {
        Map requestMap = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
        if ("persistent".equals(requestMap.get("servletkey"))) {
            return false;
        }
        if (this.delegateNonIface) {
            return !viewId.endsWith(".iface");
        }
        return false;
    }

    private void initializeParameters(FacesContext context) {
        if (this.parametersInitialized) {
            return;
        }
        ExternalContext ec = context.getExternalContext();
        String delegateNonIfaceParameter = ec.getInitParameter(DELEGATE_NONIFACE);
        String reloadIntervalParameter = ec.getInitParameter(RELOAD_INTERVAL);
        String jsfStateManagementParameter = ec.getInitParameter(DO_JSF_STATE_MANAGEMENT);
        this.actionURLSuffix = ec.getInitParameter(ACTION_URL_SUFFIX);
        this.delegateNonIface = delegateNonIfaceParameter == null ? this.delegateNonIfaceDefault : Boolean.valueOf(delegateNonIfaceParameter);
        try {
            this.reloadInterval = Long.parseLong(reloadIntervalParameter) * 1000L;
        }
        catch (NumberFormatException e) {
            this.reloadInterval = this.reloadIntervalDefault * 1000L;
        }
        this.jsfStateManagement = Boolean.valueOf(jsfStateManagementParameter);
        if (!this.jsfStateManagement) {
            log.debug((Object)"JSF State Management not provided");
        }
        this.parametersInitialized = true;
    }

    private static String mungeViewId(String viewId) {
        String defaultSuffix = FacesContext.getCurrentInstance().getExternalContext().getInitParameter("javax.faces.DEFAULT_SUFFIX");
        String suffix = defaultSuffix != null ? defaultSuffix : ".jsp";
        int dot = viewId.lastIndexOf(46);
        if (dot == -1) {
            log.error((Object)("Assumed extension mapping, but there is no extension in " + viewId));
        } else {
            viewId = viewId.substring(0, dot) + suffix;
        }
        return viewId;
    }

    private static UIComponent findComponent(UIComponent uiComponent, String componentId) {
        UIComponent component = null;
        UIComponent child = null;
        if (componentId.equals(uiComponent.getId())) {
            return uiComponent;
        }
        Iterator children = uiComponent.getFacetsAndChildren();
        while (children.hasNext() && component == null) {
            child = (UIComponent)children.next();
            if (!(child instanceof NamingContainer)) {
                component = D2DViewHandler.findComponent(child, componentId);
                if (component == null) continue;
                break;
            }
            if (!componentId.endsWith(child.getId())) continue;
            component = child;
            break;
        }
        return component;
    }

    static {
        if (log.isInfoEnabled()) {
            log.info((Object)new ProductInfo().toString());
        }
    }
}

