/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.async.render;

import com.icesoft.faces.async.render.RejectionHandler;
import com.icesoft.faces.async.render.RenderThreadFactory;
import com.icesoft.faces.async.render.Renderable;
import com.icesoft.faces.async.render.RunnableRender;
import com.icesoft.faces.async.render.SingleEntryQueue;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionHandler;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RenderHub {
    private static Log log = LogFactory.getLog((Class)RenderHub.class);
    private ThreadPoolExecutor renderService;
    private int corePoolSize = 10;
    private int maxPoolSize = 15;
    private long keepAliveTime = 300000L;
    private int renderQueueCapacity = 1000;
    private ScheduledThreadPoolExecutor scheduledService;
    private int schedulePoolSize = 5;
    private RejectionHandler rejectionHandler = new RejectionHandler();
    private RenderThreadFactory threadFactory = new RenderThreadFactory();

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public int getRenderQueueCapacity() {
        return this.renderQueueCapacity;
    }

    public void setRenderQueueCapacity(int renderQueueCapacity) {
        this.renderQueueCapacity = renderQueueCapacity;
    }

    public void requestRender(Renderable renderable) {
        if (this.renderService == null) {
            this.createCoreService();
        }
        this.renderService.execute((Runnable)new RunnableRender(renderable));
    }

    private synchronized void createCoreService() {
        SingleEntryQueue queue = new SingleEntryQueue(this.renderQueueCapacity);
        this.renderService = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, this.keepAliveTime, TimeUnit.MILLISECONDS, (BlockingQueue)queue, (ThreadFactory)this.threadFactory, (RejectedExecutionHandler)this.rejectionHandler);
        if (log.isInfoEnabled()) {
            log.info((Object)("core render service created:\n  core pool size : " + this.corePoolSize + "\n  max pool size  : " + this.maxPoolSize + "\n  keep alive time: " + this.keepAliveTime));
        }
    }

    public ScheduledThreadPoolExecutor getScheduledService() {
        if (this.scheduledService == null) {
            this.createScheduledService();
        }
        return this.scheduledService;
    }

    protected synchronized void createScheduledService() {
        this.scheduledService = new ScheduledThreadPoolExecutor(this.corePoolSize, (ThreadFactory)this.threadFactory, (RejectedExecutionHandler)this.rejectionHandler);
        if (log.isInfoEnabled()) {
            log.info((Object)("scheduled render service created:\n  core pool size : " + this.schedulePoolSize));
        }
    }

    public int getSchedulePoolSize() {
        return this.schedulePoolSize;
    }

    public void setSchedulePoolSize(int schedulePoolSize) {
        this.schedulePoolSize = schedulePoolSize;
    }

    public void dispose() {
        if (this.renderService != null) {
            this.renderService.shutdown();
            this.renderService = null;
        }
        if (this.scheduledService != null) {
            this.scheduledService.shutdown();
            this.scheduledService = null;
        }
    }
}

