/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context;

import com.icesoft.faces.application.D2DViewHandler;
import com.icesoft.faces.application.StartupTime;
import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.context.DOMSerializer;
import com.icesoft.faces.context.ElementController;
import com.icesoft.faces.context.effects.JavascriptContext;
import com.icesoft.faces.util.CoreUtils;
import com.icesoft.faces.webapp.http.common.Configuration;
import java.beans.Beans;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMResponseWriter
extends ResponseWriter {
    private static final Log log = LogFactory.getLog((Class)DOMResponseWriter.class);
    public static final String STREAM_WRITING = "com.icesoft.faces.streamWriting";
    public static final String DOCTYPE_PUBLIC = "com.icesoft.doctype.public";
    public static final String DOCTYPE_SYSTEM = "com.icesoft.doctype.system";
    public static final String DOCTYPE_ROOT = "com.icesoft.doctype.root";
    public static final String DOCTYPE_OUTPUT = "com.icesoft.doctype.output";
    public static final String DOCTYPE_PRETTY_PRINTING = "com.icesoft.doctype.prettyprinting";
    public static final String RESPONSE_DOM = "com.icesoft.domResponseDocument";
    public static final String RESPONSE_DOM_ID = "com.icesoft.domResponseDocumentID";
    public static final String OLD_DOM = "com.icesoft.oldDocument";
    public static final String RESPONSE_VIEWROOT = "com.icesoft.domResponseViewRoot";
    public static final String RESPONSE_CONTEXTS_TABLE = "com.icesoft.domResponseContexts";
    private static DocumentBuilder DOCUMENT_BUILDER;
    private static boolean isStreamWritingFlag;
    private Document document;
    private Node cursor;
    private Map domResponseContexts;
    private Map contextServletTable;
    private BridgeFacesContext context;
    private DOMSerializer serializer;
    private Configuration configuration;

    public DOMResponseWriter(FacesContext context, DOMSerializer serializer, Configuration configuration) {
        this.serializer = serializer;
        this.configuration = configuration;
        try {
            this.context = (BridgeFacesContext)context;
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("ICEfaces requires the PersistentFacesServlet. Please check your web.xml servlet mappings");
        }
        this.initialize();
    }

    Map getDomResponseContexts() {
        return this.domResponseContexts;
    }

    public Node getCursorParent() {
        return this.cursor;
    }

    public Document getDocument() {
        return this.document;
    }

    public String getContentType() {
        return "text/html; charset=UTF-8";
    }

    public String getCharacterEncoding() {
        return "UTF-8";
    }

    public void startDocument() throws IOException {
    }

    private void initialize() {
        this.contextServletTable = D2DViewHandler.getContextServletTable(this.context);
        if (this.contextServletTable.containsKey(RESPONSE_CONTEXTS_TABLE)) {
            this.domResponseContexts = (Map)this.contextServletTable.get(RESPONSE_CONTEXTS_TABLE);
        }
        if (null == this.domResponseContexts) {
            this.domResponseContexts = new HashMap();
            this.contextServletTable.put(RESPONSE_CONTEXTS_TABLE, this.domResponseContexts);
        }
        this.contextServletTable.put(RESPONSE_VIEWROOT, this.context.getViewRoot());
        this.document = DOCUMENT_BUILDER.newDocument();
        this.cursor = this.document;
        this.contextServletTable.put(RESPONSE_DOM, this.document);
        boolean streamWritingParam = "true".equalsIgnoreCase(this.context.getExternalContext().getInitParameter(STREAM_WRITING));
        isStreamWritingFlag = Beans.isDesignTime() || streamWritingParam;
    }

    public void endDocument() throws IOException {
        if (!DOMResponseWriter.isStreamWriting()) {
            this.enhanceAndFixDocument();
            this.serializer.serialize(this.document);
        }
    }

    public void flush() throws IOException {
    }

    public void startElement(String name, UIComponent componentForElement) throws IOException {
        Node oldCursor = this.cursor;
        Element elem = this.document.createElement(name);
        this.cursor = this.cursor.appendChild(elem);
        if (log.isTraceEnabled()) {
            log.trace((Object)("startElement()  name: " + name + "  elem: " + elem + "  oldCursor: " + oldCursor + "  newCursor: " + this.cursor));
        }
    }

    public void endElement(String name) throws IOException {
        Node oldCursor = this.cursor;
        this.cursor = this.cursor.getParentNode();
        if (log.isTraceEnabled()) {
            log.trace((Object)("endElement()  name: " + name + "  oldCursor: " + oldCursor + "  newCursor: " + this.cursor));
        }
    }

    public void writeAttribute(String name, Object value, String componentPropertyName) throws IOException {
        ((Element)this.cursor).setAttribute(name.trim(), String.valueOf(value));
    }

    public void writeURIAttribute(String name, Object value, String componentPropertyName) throws IOException {
        String stringValue = String.valueOf(value);
        if (stringValue.startsWith("javascript:")) {
            ((Element)this.cursor).setAttribute(name, stringValue);
        } else {
            ((Element)this.cursor).setAttribute(name, stringValue.replace(' ', '+'));
        }
    }

    public void writeComment(Object comment) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("writeComment()  comment: " + comment));
        }
        this.cursor.appendChild(this.document.createComment(String.valueOf(comment)));
    }

    public void writeText(Object text, String componentPropertyName) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("writeText(O,S)  text: " + text));
        }
        this.cursor.appendChild(this.document.createTextNode(String.valueOf(text)));
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("writeText(c[],i,i)  text: " + new String(text, off, len)));
        }
        this.cursor.appendChild(this.document.createTextNode(new String(text, off, len)));
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        if (null != this.document) {
            try {
                this.endDocument();
            }
            catch (IOException e) {
                throw new IllegalStateException(e.toString());
            }
        }
        try {
            return new DOMResponseWriter(this.context, this.serializer, this.configuration);
        }
        catch (FacesException e) {
            throw new IllegalStateException();
        }
    }

    public void close() throws IOException {
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("writeText(c[],i,i)  str: " + new String(cbuf, off, len)));
        }
        this.cursor.appendChild(this.document.createTextNode(new String(cbuf, off, len)));
    }

    public void write(int c) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("write(i)  hex: " + Integer.toHexString(c) + "  decimal: " + c));
        }
        this.cursor.appendChild(this.document.createTextNode(String.valueOf((char)c)));
    }

    public void write(String str) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("write(S)  str: " + str));
        }
        this.cursor.appendChild(this.document.createTextNode(str));
    }

    public void write(String str, int off, int len) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("write(S,i,i)  str_sub: " + str.substring(off, len)));
        }
        this.cursor.appendChild(this.document.createTextNode(str.substring(off, len)));
    }

    private void enhanceAndFixDocument() {
        Element html = this.document.getDocumentElement();
        html = "html".equals(html.getTagName()) ? html : this.fixHtml();
        this.enhanceHtml(html);
        Element head = (Element)this.document.getElementsByTagName("head").item(0);
        this.enhanceHead(head == null ? this.fixHead() : head);
        Element body = (Element)this.document.getElementsByTagName("body").item(0);
        this.enhanceBody(body == null ? this.fixBody() : body);
    }

    private void enhanceHtml(Element html) {
        Locale locale = this.context.getApplication().getViewHandler().calculateLocale((FacesContext)this.context);
        html.setAttribute("lang", locale.getLanguage());
    }

    private void enhanceBody(Element body) {
        HttpServletRequest httpRequest;
        body.setAttribute("id", "body");
        Element iframe = this.document.createElement("iframe");
        body.insertBefore(iframe, body.getFirstChild());
        iframe.setAttribute("id", "history-frame");
        Object request = this.context.getExternalContext().getRequest();
        String frameURI = request instanceof HttpServletRequest ? ((httpRequest = (HttpServletRequest)request).getRequestURI() == null ? "about:blank" : CoreUtils.resolveResourceURL(FacesContext.getCurrentInstance(), "/xmlhttp/blank.iface")) : "about:blank";
        iframe.setAttribute("title", "Icefaces Redirect");
        iframe.setAttribute("src", frameURI);
        iframe.setAttribute("frameborder", "0");
        iframe.setAttribute("style", "z-index: 10000; visibility: hidden; width: 0; height: 0; position: absolute; opacity: 0.22; filter: alpha(opacity=22);");
        String focusId = this.context.getFocusId();
        if (focusId != null && !focusId.equals("null")) {
            JavascriptContext.focus(this.context, focusId);
        }
        Element script = (Element)body.appendChild(this.document.createElement("script"));
        script.setAttribute("id", "dynamic-code");
        script.setAttribute("language", "javascript");
        String calls = JavascriptContext.getJavascriptCalls(this.context);
        script.appendChild(this.document.createTextNode(calls));
        Map session = this.context.getExternalContext().getSessionMap();
        ElementController.from(session).addInto(body);
        String sessionIDScript = "window.session='" + this.context.getIceFacesId() + "'; ";
        String configurationScript = "window.configuration = {synchronous: " + this.configuration.getAttribute("synchronousUpdate", "false") + "," + "redirectURI: " + this.configuration.getAttribute("connectionLostRedirectURI", "null") + "," + "connection: {" + "context: '" + this.context.getApplication().getViewHandler().getResourceURL((FacesContext)this.context, "/") + "'," + "timeout: " + this.configuration.getAttributeAsLong("connectionTimeout", 30000L) + "," + "heartbeat: {" + "interval: " + this.configuration.getAttributeAsLong("heartbeatInterval", 20000L) + "," + "timeout: " + this.configuration.getAttributeAsLong("heartbeatTimeout", 3000L) + "," + "retries: " + this.configuration.getAttributeAsLong("heartbeatRetries", 3L) + "}" + "}" + "};";
        Element configurationElement = (Element)body.appendChild(this.document.createElement("script"));
        configurationElement.setAttribute("language", "javascript");
        configurationElement.appendChild(this.document.createTextNode(sessionIDScript + configurationScript));
        body.appendChild(configurationElement);
    }

    private void enhanceHead(Element head) {
        ViewHandler handler = this.context.getApplication().getViewHandler();
        head.setAttribute("id", "head");
        Element meta = (Element)head.appendChild(this.document.createElement("meta"));
        meta.setAttribute("name", "icefaces");
        meta.setAttribute("content", "Rendered by ICEFaces D2D");
        Element noscript = (Element)head.appendChild(this.document.createElement("noscript"));
        Element noscriptMeta = (Element)noscript.appendChild(this.document.createElement("meta"));
        noscriptMeta.setAttribute("http-equiv", "refresh");
        noscriptMeta.setAttribute("content", "0;url=" + handler.getResourceURL((FacesContext)this.context, "/xmlhttp/javascript-blocked"));
        ArrayList<String> libs = new ArrayList<String>();
        if (this.context.getExternalContext().getInitParameter("com.icesoft.faces.openAjaxHub") != null) {
            libs.add("/xmlhttp/openajax.js");
        }
        libs.add("/xmlhttp" + StartupTime.getStartupInc() + "icefaces-d2d.js");
        libs.add("/xmlhttp" + StartupTime.getStartupInc() + "ice-extras.js");
        if (this.context.getExternalContext().getRequestMap().get("javax.servlet.include.servlet_path") == null) {
            String[] componentLibs = JavascriptContext.getIncludedLibs(this.context);
            for (int i = 0; i < componentLibs.length; ++i) {
                String componentLib = componentLibs[i];
                if (libs.contains(componentLib)) continue;
                libs.add(componentLib);
            }
        }
        Iterator iterator = libs.iterator();
        while (iterator.hasNext()) {
            String lib = (String)iterator.next();
            Element script = (Element)head.appendChild(this.document.createElement("script"));
            script.setAttribute("language", "javascript");
            script.setAttribute("src", handler.getResourceURL((FacesContext)this.context, lib));
        }
        String sessionIdentifier = this.context.getIceFacesId();
        Element viewAndSessionScript = (Element)head.appendChild(this.document.createElement("script"));
        viewAndSessionScript.setAttribute("language", "javascript");
        viewAndSessionScript.appendChild(this.document.createTextNode("window.session = '" + sessionIdentifier + "';"));
    }

    private Element fixHtml() {
        Element root = this.document.getDocumentElement();
        Element html = this.document.createElement("html");
        this.document.replaceChild(html, root);
        html.appendChild(root);
        return html;
    }

    private Element fixBody() {
        int i;
        Element html = this.document.getDocumentElement();
        Element body = this.document.createElement("body");
        NodeList children = html.getChildNodes();
        int length = children.getLength();
        Node[] nodes = new Node[length];
        for (i = 0; i < nodes.length; ++i) {
            nodes[i] = children.item(i);
        }
        for (i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            if (node instanceof Element && "head".equals(((Element)node).getTagName())) continue;
            body.appendChild(node);
        }
        html.appendChild(body);
        return body;
    }

    private Element fixHead() {
        Element html = this.document.getDocumentElement();
        Element head = this.document.createElement("head");
        html.insertBefore(head, html.getFirstChild());
        return head;
    }

    protected void setCursorParent(Node cursorParent) {
        this.cursor = cursorParent;
    }

    public static boolean isStreamWriting() {
        return isStreamWritingFlag;
    }

    static {
        try {
            DOCUMENT_BUILDER = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Cannot acquire a DocumentBuilder", (Throwable)e);
        }
        isStreamWritingFlag = false;
    }
}

