/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context;

import com.icesoft.faces.context.DOMSerializer;
import com.icesoft.faces.util.DOMUtils;
import com.icesoft.faces.webapp.command.CommandQueue;
import com.icesoft.faces.webapp.command.UpdateElements;
import java.io.IOException;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PushModeSerializer
implements DOMSerializer {
    private Document oldDocument;
    private CommandQueue commandQueue;

    public PushModeSerializer(Document currentDocument, CommandQueue commandQueue) {
        this.oldDocument = currentDocument;
        this.commandQueue = commandQueue;
    }

    public void serialize(Document document) throws IOException {
        Node[] changed = DOMUtils.domDiff(this.oldDocument, document);
        for (int i = 0; i < changed.length; ++i) {
            Element changeRoot = DOMUtils.ascendToNodeWithID(changed[i]);
            for (int j = 0; j < i; ++j) {
                if (changed[j] == null) continue;
                if (changeRoot == changed[j]) {
                    changeRoot = null;
                    break;
                }
                if (this.isAncestor(changeRoot, changed[j])) {
                    changed[j] = null;
                    continue;
                }
                if (!this.isAncestor(changed[j], changeRoot)) continue;
                changeRoot = null;
                break;
            }
            changed[i] = changeRoot;
        }
        ArrayList<Element> elementList = new ArrayList<Element>(changed.length);
        for (int i = 0; i < changed.length; ++i) {
            Element element = (Element)changed[i];
            if (null == element) continue;
            elementList.add(element);
        }
        if (!elementList.isEmpty()) {
            Element[] elements = elementList.toArray(new Element[elementList.size()]);
            this.commandQueue.put(new UpdateElements(elements));
        }
        this.oldDocument = document;
    }

    private boolean isAncestor(Node test, Node child) {
        if (test == null || child == null) {
            return false;
        }
        if (!test.hasChildNodes()) {
            return false;
        }
        Node parent = child;
        while ((parent = parent.getParentNode()) != null) {
            if (!test.equals(parent)) continue;
            return true;
        }
        return false;
    }
}

