/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlPanelGrid;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;

public class GridRenderer
extends DomBasicRenderer {
    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Element root;
        this.validateParameters(facesContext, uiComponent, null);
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        if (!domContext.isInitialized()) {
            root = domContext.createElement("table");
            domContext.setRootNode(root);
            GridRenderer.setRootElementId(facesContext, root, uiComponent);
            PassThruAttributeRenderer.renderAttributes(facesContext, uiComponent, null);
        }
        root = (Element)domContext.getRootNode();
        String styleClass = ((HtmlPanelGrid)uiComponent).getStyleClass();
        if (styleClass != null) {
            root.setAttribute("class", styleClass);
        }
    }

    private void renderHeaderFacet(FacesContext facesContext, UIComponent uiComponent, DOMContext domContext) throws IOException {
        Element root = (Element)domContext.getRootNode();
        DOMContext.removeChildrenByTagName(root, "thead");
        UIComponent headerFacet = GridRenderer.getFacetByName(uiComponent, "header");
        if (headerFacet != null && headerFacet.isRendered()) {
            Element thead = domContext.createElement("thead");
            Element tr = domContext.createElement("tr");
            Element th = domContext.createElement("th");
            root.appendChild(thead);
            thead.appendChild(tr);
            tr.appendChild(th);
            String headerClassAttribute = ((HtmlPanelGrid)uiComponent).getHeaderClass();
            if (headerClassAttribute != null) {
                th.setAttribute("class", headerClassAttribute);
            }
            th.setAttribute("scope", "colgroup");
            th.setAttribute("colspan", String.valueOf(this.getConvertedColumnAttribute(uiComponent)));
            domContext.setCursorParent(th);
            domContext.streamWrite(facesContext, uiComponent, domContext.getRootNode(), th);
            GridRenderer.encodeParentAndChildren(facesContext, headerFacet);
        }
    }

    private void renderFooterFacet(FacesContext facesContext, UIComponent uiComponent, DOMContext domContext) throws IOException {
        Element root = (Element)domContext.getRootNode();
        DOMContext.removeChildrenByTagName(root, "tfoot");
        UIComponent footerFacet = GridRenderer.getFacetByName(uiComponent, "footer");
        if (footerFacet != null && footerFacet.isRendered()) {
            Element tfoot = domContext.createElement("tfoot");
            Element tr = domContext.createElement("tr");
            Element td = domContext.createElement("td");
            root.appendChild(tfoot);
            tfoot.appendChild(tr);
            tr.appendChild(td);
            String footerClassAttribute = ((HtmlPanelGrid)uiComponent).getFooterClass();
            if (footerClassAttribute != null) {
                td.setAttribute("class", footerClassAttribute);
            }
            td.setAttribute("colspan", String.valueOf(this.getConvertedColumnAttribute(uiComponent)));
            domContext.setCursorParent(td);
            domContext.streamWrite(facesContext, uiComponent, domContext.getRootNode(), td);
            GridRenderer.encodeParentAndChildren(facesContext, footerFacet);
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, null);
        DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
        this.renderHeaderFacet(facesContext, uiComponent, domContext);
        Element root = (Element)domContext.getRootNode();
        DOMContext.removeChildrenByTagName(root, "tbody");
        Element tbody = domContext.createElement("tbody");
        root.appendChild(tbody);
        Element tr = null;
        Iterator children = uiComponent.getChildren().iterator();
        if (children != null) {
            int numberOfColumns = this.getConvertedColumnAttribute(uiComponent);
            int rowIndex = -1;
            int columnIndex = numberOfColumns;
            String[] columnStyleClasses = this.getColumnStyleClasses(uiComponent);
            String[] rowStyleClasses = this.getRowStyles(uiComponent);
            int columnStyleIndex = 0;
            int rowStyleIndex = 0;
            int numberOfColumnStyles = columnStyleClasses.length - 1;
            int numberOfRowStyles = rowStyleClasses.length;
            Object facet = null;
            while (children.hasNext()) {
                UIComponent nextChild = (UIComponent)children.next();
                if (!nextChild.isRendered()) continue;
                if (columnIndex >= numberOfColumns) {
                    tr = domContext.createElement("tr");
                    tbody.appendChild(tr);
                    if (numberOfRowStyles > 0) {
                        tr.setAttribute("class", rowStyleClasses[rowStyleIndex++]);
                        if (rowStyleIndex >= numberOfRowStyles) {
                            rowStyleIndex = 0;
                        }
                    }
                    columnStyleIndex = 0;
                    columnIndex = 0;
                    ++rowIndex;
                }
                Element td = domContext.createElement("td");
                tr.appendChild(td);
                td.setAttribute("id", this.getIndexedClientId(facesContext, uiComponent, columnIndex, rowIndex));
                this.writeColStyles(columnStyleClasses, numberOfColumnStyles, columnStyleIndex, td, columnIndex + 1, uiComponent);
                if (++columnStyleIndex > numberOfColumnStyles) {
                    columnStyleIndex = 0;
                }
                domContext.setCursorParent(td);
                domContext.streamWrite(facesContext, uiComponent, domContext.getRootNode(), td);
                GridRenderer.encodeParentAndChildren(facesContext, nextChild);
                ++columnIndex;
            }
        }
        this.renderFooterFacet(facesContext, uiComponent, domContext);
        domContext.stepOver();
        domContext.streamWrite(facesContext, uiComponent);
    }

    public String[] getRowStyles(UIComponent uiComponent) {
        return this.getRowStyleClasses(uiComponent);
    }

    private String getIndexedClientId(FacesContext facesContext, UIComponent uiComponent, int columnIndex, int rowIndex) {
        return uiComponent.getClientId(facesContext) + "-" + rowIndex + "-" + columnIndex;
    }

    private int getConvertedColumnAttribute(UIComponent uiComponent) {
        int value;
        int convertedColumnAttribute = 1;
        Object columnAttribute = uiComponent.getAttributes().get("columns");
        if (columnAttribute != null && columnAttribute instanceof Integer && (value = ((Integer)columnAttribute).intValue()) > 0) {
            convertedColumnAttribute = value;
        }
        return convertedColumnAttribute;
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, null);
    }

    public void writeColStyles(String[] columnStyles, int columnStylesMaxIndex, int columnStyleIndex, Element td, int colNumber, UIComponent uiComponent) {
        if (columnStyles.length > 0 && columnStylesMaxIndex >= 0) {
            td.setAttribute("class", columnStyles[columnStyleIndex]);
            if (++columnStyleIndex > columnStylesMaxIndex) {
                columnStyleIndex = 0;
            }
        }
    }

    protected String getRowStyle(UIComponent uiComponent, String style) {
        return style;
    }
}

