/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class OutputLinkRenderer
extends DomBasicRenderer {
    String clientId;

    public boolean getRendersChildren() {
        return true;
    }

    protected Object getValue(UIComponent uiComponent) {
        return ((UIOutput)uiComponent).getValue();
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        if (facesContext == null || uiComponent == null) {
            throw new NullPointerException("facesContext or uiComponent is null");
        }
        UIOutput output = (UIOutput)uiComponent;
        String linkVal = this.getValue(facesContext, uiComponent);
        if (!output.isRendered()) {
            return;
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        if (writer == null) {
            throw new NullPointerException("ResponseWriter is null");
        }
        writer.startElement("a", uiComponent);
        writer.writeAttribute("id", (Object)uiComponent.getClientId(facesContext), "id");
        if (null == linkVal || 0 == linkVal.length()) {
            linkVal = "";
        }
        this.clientId = output.getClientId(facesContext);
        linkVal = this.appendParameters(facesContext, uiComponent, linkVal);
        if (!this.checkDisabled(uiComponent)) {
            writer.writeURIAttribute("href", (Object)facesContext.getExternalContext().encodeResourceURL(linkVal), "href");
        }
        PassThruAttributeWriter.renderAttributes(writer, uiComponent, null);
        String styleClass = (String)output.getAttributes().get("styleClass");
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        writer.flush();
    }

    protected boolean checkDisabled(UIComponent uiComponent) {
        return false;
    }

    private String appendParameters(FacesContext facesContext, UIComponent uiComponent, String hrefAttribute) {
        boolean parametersExist;
        StringBuffer hrefBuffer = new StringBuffer(hrefAttribute);
        Map parameters = OutputLinkRenderer.getParameterMap(uiComponent);
        int numberOfParameters = parameters.size();
        boolean bl = parametersExist = numberOfParameters > 0;
        if (parametersExist) {
            hrefBuffer.append("?");
            Iterator parameterKeys = parameters.keySet().iterator();
            while (parameterKeys.hasNext()) {
                String nextKey = (String)parameterKeys.next();
                Object nextValue = parameters.get(nextKey);
                hrefBuffer.append(nextKey);
                hrefBuffer.append("=");
                hrefBuffer.append(nextValue == null ? null : nextValue.toString());
                if (!parameterKeys.hasNext()) continue;
                hrefBuffer.append("&");
            }
        }
        return hrefBuffer.toString();
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, UIOutput.class);
        Iterator children = uiComponent.getChildren().iterator();
        while (children.hasNext()) {
            UIComponent nextChild = (UIComponent)children.next();
            nextChild.encodeBegin(facesContext);
            if (nextChild.getRendersChildren()) {
                nextChild.encodeChildren(facesContext);
            }
            nextChild.encodeEnd(facesContext);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        if (facesContext == null || uiComponent == null) {
            throw new NullPointerException("facesContext or uiComponent is null");
        }
        UIOutput output = (UIOutput)uiComponent;
        if (!output.isRendered()) {
            return;
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        if (writer == null) {
            throw new NullPointerException("ResponseWriter is null");
        }
        writer.endElement("a");
    }
}

