/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.util.event.servlet;

import com.icesoft.faces.util.event.servlet.ContextDestroyedEvent;
import com.icesoft.faces.util.event.servlet.ContextEvent;
import com.icesoft.faces.util.event.servlet.ContextEventListener;
import com.icesoft.faces.util.event.servlet.ContextEventPublisher;
import com.icesoft.faces.util.event.servlet.ContextInitializedEvent;
import com.icesoft.faces.util.event.servlet.ICEfacesIDDisposedEvent;
import com.icesoft.faces.util.event.servlet.ICEfacesIDRetrievedEvent;
import com.icesoft.faces.util.event.servlet.SessionDestroyedEvent;
import com.icesoft.faces.util.event.servlet.ViewNumberRetrievedEvent;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContextEventRepeater
implements HttpSessionListener,
ServletContextListener {
    private static SessionDispatcher.Listener SessionDispatcherListener = new SessionDispatcher.Listener();
    private static final String ASYNC_SERVER_KEY = "com.icesoft.faces.async.server";
    private static final String MESSAGING_CONTEXT_EVENT_PUBLISHER_CLASS_NAME = "com.icesoft.faces.util.event.servlet.MessagingContextEventPublisher";
    private static Log log = LogFactory.getLog((Class)ContextEventRepeater.class);
    private static Map bufferedContextEvents = new HashMap();
    private static ContextEventPublisher contextEventPublisher;
    private static Map listeners;

    public static synchronized void addListener(ContextEventListener listener) {
        if (listener == null || listeners.containsKey(listener)) {
            return;
        }
        listeners.put(listener, null);
        if (listener.receiveBufferedEvents()) {
            ContextEventRepeater.sendBufferedEvents(listener);
        }
    }

    public synchronized void contextDestroyed(ServletContextEvent event) {
        SessionDispatcherListener.contextDestroyed(event);
        ContextDestroyedEvent contextDestroyedEvent = new ContextDestroyedEvent(event);
        Iterator it = listeners.keySet().iterator();
        while (it.hasNext()) {
            ((ContextEventListener)it.next()).contextDestroyed(contextDestroyedEvent);
        }
        listeners.clear();
        bufferedContextEvents.clear();
        if (contextEventPublisher != null) {
            contextEventPublisher.publish(contextDestroyedEvent);
        }
        if (log.isInfoEnabled()) {
            ServletContext servletContext = contextDestroyedEvent.getServletContext();
            log.info((Object)("Servlet Context Name: " + servletContext.getServletContextName() + ", " + "Server Info: " + servletContext.getServerInfo()));
        }
    }

    public synchronized void contextInitialized(ServletContextEvent event) {
        block10: {
            boolean _asyncServer;
            SessionDispatcherListener.contextInitialized(event);
            String _asyncServerValue = event.getServletContext().getInitParameter(ASYNC_SERVER_KEY);
            if (_asyncServerValue != null) {
                _asyncServer = Boolean.valueOf(_asyncServerValue);
            } else {
                _asyncServer = false;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"com.icesoft.faces.async.server not defined.");
                }
            }
            if (_asyncServer) {
                try {
                    contextEventPublisher = (ContextEventPublisher)Class.forName(MESSAGING_CONTEXT_EVENT_PUBLISHER_CLASS_NAME).newInstance();
                    contextEventPublisher.setContextEventRepeater(this);
                    contextEventPublisher.publish(new ContextInitializedEvent(event));
                }
                catch (ClassNotFoundException exception) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"MessagingContextEventPublisher is not found!");
                    }
                }
                catch (IllegalAccessException exception) {
                    if (log.isFatalEnabled()) {
                        log.fatal((Object)"Failed to access constructor of MessagingContextEventPublisher!", (Throwable)exception);
                    }
                }
                catch (InstantiationException exception) {
                    if (!log.isFatalEnabled()) break block10;
                    log.fatal((Object)"Failed to instantiate MessagingContextEventPublisher!", (Throwable)exception);
                }
            }
        }
    }

    public static synchronized void iceFacesIdDisposed(HttpSession source, String iceFacesId) {
        ICEfacesIDDisposedEvent iceFacesIdDisposedEvent = new ICEfacesIDDisposedEvent(source, iceFacesId);
        bufferedContextEvents.put(iceFacesIdDisposedEvent, source);
        Iterator _listeners = listeners.keySet().iterator();
        while (_listeners.hasNext()) {
            ((ContextEventListener)_listeners.next()).iceFacesIdDisposed(iceFacesIdDisposedEvent);
        }
        if (contextEventPublisher != null) {
            contextEventPublisher.publish(iceFacesIdDisposedEvent);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ICEfaces ID disposed: " + iceFacesIdDisposedEvent.getICEfacesID()));
        }
    }

    public static synchronized void iceFacesIdRetrieved(HttpSession source, String iceFacesId) {
        ICEfacesIDRetrievedEvent iceFacesIdRetrievedEvent = new ICEfacesIDRetrievedEvent(source, iceFacesId);
        bufferedContextEvents.put(iceFacesIdRetrievedEvent, source);
        Iterator _listeners = listeners.keySet().iterator();
        while (_listeners.hasNext()) {
            ((ContextEventListener)_listeners.next()).iceFacesIdRetrieved(iceFacesIdRetrievedEvent);
        }
        if (contextEventPublisher != null) {
            contextEventPublisher.publish(iceFacesIdRetrievedEvent);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ICEfaces ID retrieved: " + iceFacesIdRetrievedEvent.getICEfacesID()));
        }
    }

    public static synchronized void removeListener(ContextEventListener listener) {
        if (listener == null) {
            return;
        }
        listeners.remove(listener);
    }

    public synchronized void sessionCreated(HttpSessionEvent event) {
        SessionDispatcherListener.sessionCreated(event);
    }

    public synchronized void sessionDestroyed(HttpSessionEvent event) {
        SessionDispatcherListener.sessionDestroyed(event);
        String icefacesID = (String)((HttpSession)event.getSource()).getAttribute("icefacesID");
        if (icefacesID == null || icefacesID.trim().length() < 1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"session does not contain and icefacesID");
            }
            return;
        }
        SessionDestroyedEvent sessionDestroyedEvent = new SessionDestroyedEvent(event, icefacesID);
        Iterator _listeners = listeners.keySet().iterator();
        while (_listeners.hasNext()) {
            ((ContextEventListener)_listeners.next()).sessionDestroyed(sessionDestroyedEvent);
        }
        ContextEventRepeater.removeBufferedEvents(event.getSession());
        if (contextEventPublisher != null) {
            contextEventPublisher.publish(sessionDestroyedEvent);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ICEfaces ID: " + sessionDestroyedEvent.getICEfacesID()));
        }
    }

    public static synchronized void viewNumberRetrieved(HttpSession source, String icefacesID, int viewNumber) {
        ViewNumberRetrievedEvent viewNumberRetrievedEvent = new ViewNumberRetrievedEvent(source, icefacesID, viewNumber);
        bufferedContextEvents.put(viewNumberRetrievedEvent, source);
        Iterator _listeners = listeners.keySet().iterator();
        while (_listeners.hasNext()) {
            ((ContextEventListener)_listeners.next()).viewNumberRetrieved(viewNumberRetrievedEvent);
        }
        if (contextEventPublisher != null) {
            contextEventPublisher.publish(viewNumberRetrievedEvent);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("View Number: " + viewNumberRetrievedEvent.getViewNumber()));
        }
    }

    ContextEvent[] getBufferedContextEvents() {
        Set _contextEventSet = bufferedContextEvents.keySet();
        return _contextEventSet.toArray(new ContextEvent[_contextEventSet.size()]);
    }

    private static synchronized void removeBufferedEvents(HttpSession session) {
        Iterator it = bufferedContextEvents.keySet().iterator();
        Object event = null;
        HttpSession bufferedSession = null;
        while (it.hasNext()) {
            event = it.next();
            bufferedSession = (HttpSession)bufferedContextEvents.get(event);
            if (!bufferedSession.equals(session)) continue;
            it.remove();
        }
    }

    private static synchronized void sendBufferedEvents(ContextEventListener listener) {
        Iterator it = bufferedContextEvents.keySet().iterator();
        while (it.hasNext()) {
            Object event = it.next();
            if (event instanceof ICEfacesIDRetrievedEvent) {
                listener.iceFacesIdRetrieved((ICEfacesIDRetrievedEvent)event);
                continue;
            }
            if (!(event instanceof ViewNumberRetrievedEvent)) continue;
            listener.viewNumberRetrieved((ViewNumberRetrievedEvent)event);
        }
    }

    static {
        listeners = new WeakHashMap();
    }
}

