/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.command;

import com.icesoft.faces.webapp.command.Command;
import com.icesoft.faces.webapp.command.Macro;
import com.icesoft.faces.webapp.command.NOOP;
import com.icesoft.faces.webapp.command.Pong;
import com.icesoft.faces.webapp.command.Redirect;
import com.icesoft.faces.webapp.command.SessionExpired;
import com.icesoft.faces.webapp.command.UpdateElements;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.servlet.http.Cookie;

public class SetCookie
implements Command {
    private static final DateFormat CookieDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss z");
    private Cookie cookie;

    public SetCookie(Cookie cookie) {
        this.cookie = cookie;
    }

    public Command coalesceWith(Command command) {
        return command.coalesceWith(this);
    }

    public Command coalesceWith(Macro macro) {
        macro.addCommand(this);
        return macro;
    }

    public Command coalesceWith(UpdateElements updateElements) {
        return new Macro(updateElements, this);
    }

    public Command coalesceWith(Redirect redirect) {
        return new Macro(redirect, this);
    }

    public Command coalesceWith(SessionExpired sessionExpired) {
        return sessionExpired;
    }

    public Command coalesceWith(SetCookie setCookie) {
        return new Macro(setCookie, this);
    }

    public Command coalesceWith(Pong pong) {
        return new Macro(pong, this);
    }

    public Command coalesceWith(NOOP noop) {
        return this;
    }

    public void serializeTo(Writer writer) throws IOException {
        String domain;
        String path;
        writer.write("<set-cookie>");
        writer.write(this.cookie.getName());
        writer.write("=");
        writer.write(this.cookie.getValue());
        writer.write("; ");
        int maxAge = this.cookie.getMaxAge();
        if (maxAge >= 0) {
            Date expiryDate = new Date(System.currentTimeMillis() + (long)(maxAge * 1000));
            writer.write("expires=");
            writer.write(CookieDateFormat.format(expiryDate));
            writer.write("; ");
        }
        if ((path = this.cookie.getPath()) != null) {
            writer.write("path=");
            writer.write(path);
            writer.write("; ");
        }
        if ((domain = this.cookie.getDomain()) != null) {
            writer.write("domain=");
            writer.write(domain);
            writer.write("; ");
        }
        if (this.cookie.getSecure()) {
            writer.write("secure;");
        }
        writer.write("</set-cookie>");
    }

    static {
        CookieDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

