/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.core;

import com.icesoft.faces.application.D2DViewHandler;
import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.core.SendUpdates;
import com.icesoft.util.SeamUtilities;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;

public class ReceiveSendUpdates
implements Server {
    private static final String REQUIRED = "required";
    private static final LifecycleFactory LifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
    private Lifecycle lifecycle = LifecycleFactory.getLifecycle("DEFAULT");
    private Map commandQueues;
    private Collection synchronouslyUpdatedViews;

    public ReceiveSendUpdates(Map commandQueues, Collection synchronouslyUpdatedViews) {
        this.commandQueues = commandQueues;
        this.synchronouslyUpdatedViews = synchronouslyUpdatedViews;
    }

    public void service(Request request) throws Exception {
        List<String> viewIdentifiers = Arrays.asList(request.getParameterAsStrings("viewNumber"));
        this.synchronouslyUpdatedViews.addAll(viewIdentifiers);
        FacesContext context = FacesContext.getCurrentInstance();
        if (request.getParameterAsBoolean("partial", false)) {
            String componentID = request.getParameter("ice.event.captured");
            UIComponent component = D2DViewHandler.findComponent(componentID, (UIComponent)context.getViewRoot());
            this.renderCyclePartial(context, component);
        } else {
            this.renderCycle(context);
        }
        request.respondWith(new SendUpdates.Handler(this.commandQueues, request));
    }

    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderCycle(FacesContext context) {
        FacesContext facesContext = context;
        synchronized (facesContext) {
            SeamUtilities.removeSeamDebugPhaseListener(this.lifecycle);
            this.lifecycle.execute(context);
            this.lifecycle.render(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderCyclePartial(FacesContext context, UIComponent component) {
        FacesContext facesContext = context;
        synchronized (facesContext) {
            Map alteredRequiredComponents = this.setRequiredFalseInFormContaining(component);
            SeamUtilities.removeSeamDebugPhaseListener(this.lifecycle);
            this.lifecycle.execute(context);
            this.lifecycle.render(context);
            this.setRequiredTrue(alteredRequiredComponents);
        }
    }

    private void setRequiredTrue(Map requiredComponents) {
        Iterator i = requiredComponents.keySet().iterator();
        UIInput next = null;
        while (i.hasNext()) {
            next = (UIInput)i.next();
            ValueBinding valueBinding = (ValueBinding)requiredComponents.get(next);
            if (null != valueBinding) {
                next.setValueBinding(REQUIRED, valueBinding);
                continue;
            }
            next.setRequired(true);
        }
    }

    private Map setRequiredFalseInFormContaining(UIComponent component) {
        HashMap alteredComponents = new HashMap();
        UIComponent form = this.getContainingForm(component);
        this.setRequiredFalseOnAllChildrenExceptOne(form, component, alteredComponents);
        return alteredComponents;
    }

    private void setRequiredFalseOnAllChildrenExceptOne(UIComponent parent, UIComponent componentToAvoid, Map alteredComponents) {
        ValueBinding FALSE_BINDING = FacesContext.getCurrentInstance().getApplication().createValueBinding("#{false}");
        int length = parent.getChildCount();
        UIComponent next = null;
        for (int i = 0; i < length; ++i) {
            UIInput input;
            next = (UIComponent)parent.getChildren().get(i);
            if (next instanceof UIInput && next != componentToAvoid && (input = (UIInput)next).isRequired()) {
                ValueBinding valueBinding = input.getValueBinding(REQUIRED);
                if (null != valueBinding) {
                    input.setValueBinding(REQUIRED, FALSE_BINDING);
                } else {
                    input.setRequired(false);
                }
                alteredComponents.put(input, valueBinding);
            }
            this.setRequiredFalseOnAllChildrenExceptOne(next, componentToAvoid, alteredComponents);
        }
    }

    private UIComponent getContainingForm(UIComponent component) {
        UIComponent parent;
        if (null == component) {
            return FacesContext.getCurrentInstance().getViewRoot();
        }
        for (parent = component.getParent(); parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        return (UIForm)parent;
    }
}

