/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.portlet;

import com.icesoft.faces.webapp.http.portlet.PortletArtifactHack;
import java.io.IOException;
import java.util.Enumeration;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MainPortlet
implements Portlet {
    private static Log log = LogFactory.getLog((Class)MainPortlet.class);
    private static final String PORTLET_MARKER = "portlet";
    private PortletConfig portletConfig;

    public void init(PortletConfig portletConfig) throws PortletException {
        this.portletConfig = portletConfig;
        if (log.isTraceEnabled()) {
            log.trace((Object)("portlet config: " + portletConfig));
        }
    }

    public void destroy() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("portlet config: " + this.portletConfig));
        }
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        if (log.isTraceEnabled()) {
            this.dumpMaps((PortletRequest)actionRequest, "portlet action request");
        }
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        PortletContext ctxt;
        PortletRequestDispatcher disp;
        if (log.isTraceEnabled()) {
            this.dumpMaps((PortletRequest)renderRequest, "portlet render request");
        }
        MainPortlet.addAttribute(renderRequest, "com.icesoft.faces.NAMESPACE", renderResponse.getNamespace());
        MainPortlet.addAttribute(renderRequest, "com.icesoft.faces.PORTLET", PORTLET_MARKER);
        PortletMode portletMode = renderRequest.getPortletMode();
        String viewId = null;
        if (portletMode == PortletMode.VIEW) {
            viewId = this.portletConfig.getInitParameter("com.icesoft.faces.VIEW");
            if (viewId == null) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"com.icesoft.faces.VIEW is not properly configured");
                }
                throw new PortletException("com.icesoft.faces.VIEW is not properly configured");
            }
        } else if (portletMode == PortletMode.EDIT) {
            viewId = this.portletConfig.getInitParameter("com.icesoft.faces.EDIT");
            if (viewId == null) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"com.icesoft.faces.EDIT is not properly configured");
                }
                throw new PortletException("com.icesoft.faces.EDIT is not properly configured");
            }
        } else if (portletMode == PortletMode.HELP && (viewId = this.portletConfig.getInitParameter("com.icesoft.faces.HELP")) == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"com.icesoft.faces.HELP is not properly configured");
            }
            throw new PortletException("com.icesoft.faces.HELP is not properly configured");
        }
        if ((disp = (ctxt = this.portletConfig.getPortletContext()).getRequestDispatcher(viewId)) == null) {
            throw new PortletException("could not find dispatcher for " + viewId);
        }
        PortletArtifactHack hack = new PortletArtifactHack(this.portletConfig, (PortletRequest)renderRequest);
        MainPortlet.addAttribute(renderRequest, "com.icesoft.faces.portletHack", hack);
        renderResponse.setContentType("text/html");
        disp.include(renderRequest, renderResponse);
    }

    private static void addAttribute(RenderRequest req, String key, Object value) {
        if (key != null && value != null) {
            req.setAttribute(key, value);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)(key + ": " + value));
        }
    }

    private void dumpMaps(PortletRequest req, String header) {
        String key;
        log.trace((Object)(header + "\n-------------------------------"));
        Enumeration keys = this.portletConfig.getInitParameterNames();
        StringBuffer buff = new StringBuffer("portlet config init parameters:\n");
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            buff.append("\t");
            buff.append(key);
            buff.append(" - ");
            buff.append(this.portletConfig.getInitParameter(key));
            buff.append("\n");
        }
        log.trace((Object)buff.toString());
        PortletContext portletContext = this.portletConfig.getPortletContext();
        keys = portletContext.getAttributeNames();
        buff = new StringBuffer("portlet context attributes:\n");
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            buff.append("\t");
            buff.append(key);
            buff.append(" - ");
            buff.append(portletContext.getAttribute(key));
            buff.append("\n");
        }
        log.trace((Object)buff.toString());
        keys = portletContext.getInitParameterNames();
        buff = new StringBuffer("portlet context init parameters:\n");
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            buff.append("\t");
            buff.append(key);
            buff.append(" - ");
            buff.append(portletContext.getInitParameter(key));
            buff.append("\n");
        }
        log.trace((Object)buff.toString());
        PortletSession session = req.getPortletSession();
        keys = session.getAttributeNames();
        buff = new StringBuffer("portlet session attributes:\n");
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            buff.append("\t");
            buff.append(key);
            buff.append(" - ");
            buff.append(session.getAttribute(key));
            buff.append("\n");
        }
        log.trace((Object)buff.toString());
        keys = req.getAttributeNames();
        buff = new StringBuffer("request attributes:\n");
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            buff.append("\t");
            buff.append(key);
            buff.append(" - ");
            buff.append(req.getAttribute(key));
            buff.append("\n");
        }
        log.trace((Object)buff.toString());
        keys = req.getParameterNames();
        buff = new StringBuffer("request parameters:\n");
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            buff.append("\t");
            buff.append(key);
            buff.append(" - ");
            buff.append(req.getParameter(key));
            buff.append("\n");
        }
        log.trace((Object)buff.toString());
        keys = req.getPropertyNames();
        buff = new StringBuffer("request properties:\n");
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            buff.append("\t");
            buff.append(key);
            buff.append(" - ");
            buff.append(req.getProperty(key));
            buff.append("\n");
        }
        log.trace((Object)buff.toString());
    }
}

