/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.util.event.servlet.ContextEventRepeater;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.core.PageServer;
import com.icesoft.faces.webapp.http.core.ViewQueue;
import com.icesoft.faces.webapp.http.servlet.BasicAdaptingServlet;
import com.icesoft.faces.webapp.http.servlet.ServletView;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class MultiViewServlet
extends BasicAdaptingServlet {
    private int viewCount = 0;
    private HttpSession session;
    private Map views;
    private ViewQueue asynchronouslyUpdatedViews;
    private String sessionID;
    private Configuration configuration;
    private SessionDispatcher.Listener.Monitor sessionMonitor;

    public MultiViewServlet(HttpSession session, String sessionID, SessionDispatcher.Listener.Monitor sessionMonitor, Map views, ViewQueue asynchronouslyUpdatedViews, Configuration configuration) {
        super(new PageServer());
        this.sessionID = sessionID;
        this.session = session;
        this.sessionMonitor = sessionMonitor;
        this.views = views;
        this.asynchronouslyUpdatedViews = asynchronouslyUpdatedViews;
        this.configuration = configuration;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServletView view;
        String redirectViewNumber = request.getParameter("rvn");
        if (redirectViewNumber == null) {
            String viewNumber = String.valueOf(++this.viewCount);
            view = new ServletView(viewNumber, this.sessionID, request, response, this.asynchronouslyUpdatedViews, this.configuration);
            this.views.put(viewNumber, view);
            ContextEventRepeater.viewNumberRetrieved(this.session, this.sessionID, Integer.parseInt(viewNumber));
        } else {
            view = (ServletView)this.views.get(redirectViewNumber);
            if (view == null) {
                view = new ServletView(redirectViewNumber, this.sessionID, request, response, this.asynchronouslyUpdatedViews, this.configuration);
                this.views.put(redirectViewNumber, view);
                ContextEventRepeater.viewNumberRetrieved(this.session, this.sessionID, Integer.parseInt(redirectViewNumber));
            } else {
                view.updateOnRequest(request, response);
                view.switchToNormalMode();
            }
        }
        this.sessionMonitor.touchSession();
        super.service(request, response);
        view.switchToPushMode();
        view.release();
    }
}

