/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.context.BridgeExternalContext;
import com.icesoft.faces.util.EnumerationIterator;
import com.icesoft.faces.webapp.command.CommandQueue;
import com.icesoft.faces.webapp.command.Redirect;
import com.icesoft.faces.webapp.command.SetCookie;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.servlet.CopyingRequestAttributesMap;
import com.icesoft.faces.webapp.http.servlet.ServletApplicationMap;
import com.icesoft.faces.webapp.http.servlet.ServletSessionMap;
import com.icesoft.util.SeamUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.render.ResponseStateManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServletExternalContext
extends BridgeExternalContext {
    private static Log log = LogFactory.getLog((Class)ServletExternalContext.class);
    private static String postBackKey;
    private String viewIdentifier;
    private ServletContext context;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private HttpSession session;
    private Map applicationMap;
    private Map sessionMap;
    private Map requestParameterMap;
    private Map requestParameterValuesMap;
    private Map initParameterMap;
    private Map requestMap;
    private Map requestCookieMap;
    private Map responseCookieMap;
    private CommandQueue commandQueue;
    private Redirector redirector;
    private CookieTransporter cookieTransporter;
    private boolean standardScope;
    private String requestPathInfo;
    private String requestServletPath;

    public ServletExternalContext(String viewIdentifier, HttpServletRequest request, HttpServletResponse response, CommandQueue commandQueue, Configuration configuration) {
        this.viewIdentifier = viewIdentifier;
        this.request = request;
        this.response = response;
        this.commandQueue = commandQueue;
        this.session = this.request.getSession();
        this.context = this.session.getServletContext();
        this.standardScope = configuration.getAttributeAsBoolean("standardRequestScope", false);
        this.applicationMap = new ServletApplicationMap(this.context);
        this.sessionMap = new ServletSessionMap(this.session);
        this.requestMap = new CopyingRequestAttributesMap((ServletRequest)this.request);
        this.requestCookieMap = new HashMap();
        this.initParameterMap = new HashMap();
        Enumeration names = this.context.getInitParameterNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            this.initParameterMap.put(key, this.context.getInitParameter(key));
        }
        this.update(request, response);
        this.insertNewViewrootToken();
    }

    public Object getSession(boolean create) {
        return this.session;
    }

    public Object getContext() {
        return this.context;
    }

    public Object getRequest() {
        return this.request;
    }

    public Object getResponse() {
        return this.response;
    }

    public Map getApplicationMap() {
        return this.applicationMap;
    }

    public Map getSessionMap() {
        return this.sessionMap;
    }

    public Map getApplicationSessionMap() {
        return this.sessionMap;
    }

    public Map getRequestMap() {
        return this.requestMap;
    }

    public void update(HttpServletRequest request, HttpServletResponse response) {
        boolean persistSeamKey = false;
        if (this.requestParameterMap != null) {
            persistSeamKey = this.requestParameterMap.containsKey("com.icesoft.faces.shortcutLifecycle");
        }
        this.requestParameterMap = new HashMap();
        this.requestParameterValuesMap = new HashMap();
        this.insertPostbackKey();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            String value = request.getParameter(name);
            this.requestParameterMap.put(name, value);
            this.requestParameterValuesMap.put(name, request.getParameterValues(name));
        }
        if (persistSeamKey) {
            this.requestParameterMap.put("com.icesoft.faces.shortcutLifecycle", Boolean.TRUE);
        }
        this.requestCookieMap = new HashMap();
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                this.requestCookieMap.put(cookie.getName(), cookie);
            }
        }
        this.responseCookieMap = new HashMap();
        this.response = response;
    }

    public void updateOnReload(HttpServletRequest request, HttpServletResponse response) {
        Map previousRequestMap = this.requestMap;
        this.requestMap = new CopyingRequestAttributesMap((ServletRequest)request);
        this.requestMap.putAll(previousRequestMap);
        this.request = request;
        this.update(request, response);
    }

    public Map getRequestParameterMap() {
        return this.requestParameterMap;
    }

    public Map getRequestParameterValuesMap() {
        return this.requestParameterValuesMap;
    }

    public Iterator getRequestParameterNames() {
        return this.requestParameterMap.keySet().iterator();
    }

    public Map getRequestHeaderMap() {
        return Collections.EMPTY_MAP;
    }

    public Map getRequestHeaderValuesMap() {
        return Collections.EMPTY_MAP;
    }

    public Map getRequestCookieMap() {
        return this.requestCookieMap;
    }

    public Locale getRequestLocale() {
        return this.request.getLocale();
    }

    public Iterator getRequestLocales() {
        return new EnumerationIterator(this.request.getLocales());
    }

    public void setRequestPathInfo(String viewId) {
        this.requestPathInfo = viewId;
    }

    public String getRequestPathInfo() {
        if (this.requestPathInfo != null && this.requestPathInfo.trim().length() > 0) {
            return this.requestPathInfo;
        }
        if (this.requestPathInfo == null) {
            this.requestPathInfo = this.request.getPathInfo();
        }
        this.requestPathInfo = ServletExternalContext.convertEmptyStringToNull(this.requestPathInfo);
        return this.requestPathInfo;
    }

    private static String convertEmptyStringToNull(String val) {
        if (val == null) {
            return val;
        }
        if (val.trim().length() == 0) {
            return null;
        }
        return val;
    }

    public String getRequestURI() {
        String uri = (String)this.request.getAttribute("javax.servlet.include.request_uri");
        if (uri == null || uri.trim().length() > 0) {
            uri = this.request.getRequestURI();
        }
        return uri;
    }

    public String getRequestContextPath() {
        return this.request.getContextPath();
    }

    public void setRequestServletPath(String path) {
        this.requestServletPath = path;
    }

    public String getRequestServletPath() {
        return null == this.requestServletPath ? this.request.getServletPath() : this.requestServletPath;
    }

    public String getInitParameter(String name) {
        return this.context.getInitParameter(name);
    }

    public Map getInitParameterMap() {
        return this.initParameterMap;
    }

    public Set getResourcePaths(String path) {
        return this.context.getResourcePaths(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.context.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.context.getResourceAsStream(path);
    }

    public String encodeActionURL(String url) {
        return url;
    }

    public String encodeResourceURL(String url) {
        try {
            return this.response.encodeURL(url);
        }
        catch (Exception e) {
            return url;
        }
    }

    public String encodeNamespace(String name) {
        String ns = (String)this.request.getAttribute("com.icesoft.faces.NAMESPACE");
        if (ns != null) {
            return ns + name;
        }
        return name;
    }

    public void dispatch(String path) throws IOException, FacesException {
        try {
            this.request.getRequestDispatcher(path).forward((ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (ServletException se) {
            throw new FacesException((Throwable)se);
        }
    }

    public void redirect(String requestURI) throws IOException {
        URI uri = URI.create(SeamUtilities.encodeSeamConversationId(requestURI, this.viewIdentifier));
        String query = uri.getQuery();
        if (query == null) {
            this.redirector.redirect(uri + "?rvn=" + this.viewIdentifier);
        } else if (query.matches(".*rvn=.*")) {
            this.redirector.redirect(uri.toString());
        } else {
            this.redirector.redirect(uri + "&rvn=" + this.viewIdentifier);
        }
        FacesContext.getCurrentInstance().responseComplete();
    }

    public void log(String message) {
        this.context.log(message);
    }

    public void log(String message, Throwable throwable) {
        this.context.log(message, throwable);
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    public void addCookie(Cookie cookie) {
        this.responseCookieMap.put(cookie.getName(), cookie);
        this.cookieTransporter.send(cookie);
    }

    public Map getResponseCookieMap() {
        return this.responseCookieMap;
    }

    public Map collectBundles() {
        HashMap result = new HashMap();
        Iterator entries = this.requestMap.entrySet().iterator();
        while (entries.hasNext()) {
            String className;
            Map.Entry entry = entries.next();
            Object value = entry.getValue();
            if (value == null || (className = value.getClass().getName()).indexOf("LoadBundleTag") <= 0 && className.indexOf("BundleMap") <= 0) continue;
            result.put(entry.getKey(), value);
        }
        return result;
    }

    public Writer getWriter(String encoding) throws IOException {
        try {
            return new OutputStreamWriter((OutputStream)this.response.getOutputStream(), encoding);
        }
        catch (IllegalStateException e) {
            return this.response.getWriter();
        }
    }

    private void insertNewViewrootToken() {
        if (SeamUtilities.isSeamEnvironment()) {
            this.requestParameterMap.put("com.icesoft.faces.shortcutLifecycle", Boolean.TRUE);
        }
    }

    public void switchToNormalMode() {
        this.redirector = new Redirector(){

            public void redirect(String uri) {
                try {
                    ServletExternalContext.this.response.sendRedirect(uri);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.cookieTransporter = new CookieTransporter(){

            public void send(Cookie cookie) {
                ServletExternalContext.this.response.addCookie(cookie);
            }
        };
    }

    public void switchToPushMode() {
        this.redirector = new Redirector(){

            public void redirect(String uri) {
                ServletExternalContext.this.commandQueue.put(new Redirect(uri));
            }
        };
        this.cookieTransporter = new CookieTransporter(){

            public void send(Cookie cookie) {
                ServletExternalContext.this.commandQueue.put(new SetCookie(cookie));
            }
        };
        this.resetRequestMap();
    }

    public void resetRequestMap() {
        if (this.standardScope) {
            this.requestMap.clear();
        }
    }

    public void injectBundles(Map bundles) {
        this.requestMap.putAll(bundles);
    }

    public void dispose() {
        this.requestMap.clear();
        this.commandQueue.take();
    }

    private void insertPostbackKey() {
        if (null != postBackKey) {
            this.requestParameterMap.put(postBackKey, "not reload");
            this.requestParameterValuesMap.put(postBackKey, new String[]{"not reload"});
        }
    }

    static {
        try {
            Field field = ResponseStateManager.class.getField("VIEW_STATE_PARAM");
            if (null != field) {
                postBackKey = (String)field.get(ResponseStateManager.class);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static interface CookieTransporter {
        public void send(Cookie var1);
    }

    private static interface Redirector {
        public void redirect(String var1);
    }
}

