/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Response;
import com.icesoft.faces.webapp.http.common.ResponseHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletRequestResponse
implements Request,
Response {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
    protected HttpServletRequest request;
    protected HttpServletResponse response;

    public ServletRequestResponse(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public URI getURI() {
        String query = this.request.getQueryString();
        URI uri = URI.create(this.request.getRequestURL().toString());
        return query == null ? uri : URI.create(uri + "?" + query);
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public String[] getHeaderAsStrings(String name) {
        Enumeration e = this.request.getHeaders(name);
        ArrayList values = new ArrayList();
        while (e.hasMoreElements()) {
            values.add(e.nextElement());
        }
        return values.toArray(new String[values.size()]);
    }

    public Date getHeaderAsDate(String name) {
        try {
            return DATE_FORMAT.parse(this.request.getHeader(name));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public int getHeaderAsInteger(String name) {
        return Integer.parseInt(this.request.getHeader(name));
    }

    public boolean containsParameter(String name) {
        return this.request.getParameter(name) != null;
    }

    public String getParameter(String name) {
        this.checkExistenceOf(name);
        return this.request.getParameter(name);
    }

    public String[] getParameterAsStrings(String name) {
        this.checkExistenceOf(name);
        return this.request.getParameterValues(name);
    }

    public int getParameterAsInteger(String name) {
        return Integer.parseInt(this.getParameter(name));
    }

    public boolean getParameterAsBoolean(String name) {
        return Boolean.valueOf(this.getParameter(name));
    }

    public String getParameter(String name, String defaultValue) {
        try {
            return this.getParameter(name);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int getParameterAsInteger(String name, int defaultValue) {
        try {
            return this.getParameterAsInteger(name);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public boolean getParameterAsBoolean(String name, boolean defaultValue) {
        try {
            return this.getParameterAsBoolean(name);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public InputStream readBody() throws IOException {
        return this.request.getInputStream();
    }

    public void readBodyInto(OutputStream out) throws IOException {
        ServletRequestResponse.copy(this.readBody(), out);
    }

    public void respondWith(ResponseHandler handler) throws Exception {
        handler.respond(this);
    }

    public void setStatus(int code) {
        this.response.setStatus(code);
    }

    public void setHeader(String name, String value) {
        if ("Content-Type".equals(name)) {
            this.response.setContentType(value);
        } else if ("Content-Length".equals(name)) {
            this.response.setContentLength(Integer.parseInt(value));
        } else {
            this.response.setHeader(name, value);
        }
    }

    public void setHeader(String name, String[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.response.addHeader(name, values[i]);
        }
    }

    public void setHeader(String name, Date value) {
        this.response.setDateHeader(name, value.getTime());
    }

    public void setHeader(String name, int value) {
        this.response.setIntHeader(name, value);
    }

    public void addCookie(Cookie cookie) {
        this.response.addCookie(cookie);
    }

    public OutputStream writeBody() throws IOException {
        return this.response.getOutputStream();
    }

    public void writeBodyFrom(InputStream in) throws IOException {
        ServletRequestResponse.copy(in, this.writeBody());
    }

    private static void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buf = new byte[4096];
        int len = 0;
        while ((len = input.read(buf)) > -1) {
            output.write(buf, 0, len);
        }
    }

    private void checkExistenceOf(String name) {
        if (this.request.getParameter(name) == null) {
            throw new RuntimeException("Query does not contain parameter named: " + name);
        }
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

