/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.webapp.http.servlet.PseudoServlet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SessionDispatcher
implements PseudoServlet {
    private static final Log Log = LogFactory.getLog((Class)SessionDispatcher.class);
    private static final List SessionDispatchers = new ArrayList();
    private Map sessionBoundServers = new HashMap();

    protected SessionDispatcher() {
        SessionDispatchers.add(this);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        if (!this.sessionBoundServers.containsKey(session.getId())) {
            throw new ServletException("Session expired");
        }
        PseudoServlet server = (PseudoServlet)this.sessionBoundServers.get(session.getId());
        server.service(request, response);
    }

    public void shutdown() {
        Iterator i = this.sessionBoundServers.values().iterator();
        while (i.hasNext()) {
            PseudoServlet server = (PseudoServlet)i.next();
            server.shutdown();
        }
    }

    private void sessionCreated(HttpSession session) {
        try {
            this.sessionBoundServers.put(session.getId(), this.newServlet(session, Listener.lookupSessionMonitor(session)));
        }
        catch (Exception e) {
            Log.warn((Object)e);
            throw new RuntimeException(e);
        }
        catch (Throwable t) {
            Log.warn((Object)t);
            throw new RuntimeException(t);
        }
    }

    private void sessionShutdown(HttpSession session) {
        PseudoServlet server = (PseudoServlet)this.sessionBoundServers.get(session.getId());
        server.shutdown();
    }

    private void sessionDestroyed(HttpSession session) {
        this.sessionBoundServers.remove(session.getId());
    }

    public static PseudoServlet getSingletonSessionServlet(HttpSession session) {
        return ((SessionDispatcher)SessionDispatchers.get(0)).getSessionServlet(session);
    }

    public PseudoServlet getSessionServlet(HttpSession session) {
        return (PseudoServlet)this.sessionBoundServers.get(session.getId());
    }

    protected abstract PseudoServlet newServlet(HttpSession var1, Listener.Monitor var2) throws Exception;

    public static class Listener
    implements HttpSessionListener,
    ServletContextListener {
        private static Map sessionMonitors = new HashMap();
        private boolean run = true;

        public void sessionCreated(HttpSessionEvent event) {
            HttpSession session = event.getSession();
            sessionMonitors.put(session, new Monitor(session));
            Iterator i = SessionDispatchers.iterator();
            while (i.hasNext()) {
                try {
                    SessionDispatcher sessionDispatcher = (SessionDispatcher)i.next();
                    sessionDispatcher.sessionCreated(session);
                }
                catch (Exception e) {
                    new RuntimeException(e);
                }
            }
        }

        public void sessionShutdown(HttpSession session) {
            Iterator i = SessionDispatchers.iterator();
            while (i.hasNext()) {
                try {
                    SessionDispatcher sessionDispatcher = (SessionDispatcher)i.next();
                    sessionDispatcher.sessionShutdown(session);
                }
                catch (Exception e) {
                    new RuntimeException(e);
                }
            }
            session.invalidate();
        }

        public void sessionDestroyed(HttpSessionEvent event) {
            HttpSession session = event.getSession();
            Iterator i = SessionDispatchers.iterator();
            while (i.hasNext()) {
                try {
                    SessionDispatcher sessionDispatcher = (SessionDispatcher)i.next();
                    sessionDispatcher.sessionDestroyed(session);
                }
                catch (Exception e) {
                    new RuntimeException(e);
                }
            }
        }

        public void contextInitialized(ServletContextEvent servletContextEvent) {
            Thread monitor = new Thread("Session Monitor"){

                public void run() {
                    while (Listener.this.run) {
                        try {
                            Iterator iterator = new ArrayList(sessionMonitors.values()).iterator();
                            while (iterator.hasNext()) {
                                Monitor sessionMonitor = (Monitor)iterator.next();
                                sessionMonitor.shutdownIfExpired();
                            }
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            };
            monitor.setDaemon(true);
            monitor.start();
        }

        public void contextDestroyed(ServletContextEvent servletContextEvent) {
            this.run = false;
        }

        public static Monitor lookupSessionMonitor(HttpSession session) {
            return (Monitor)sessionMonitors.get(session);
        }

        public class Monitor {
            private HttpSession session;
            private long lastAccess;

            public Monitor(HttpSession session) {
                this.session = session;
                this.lastAccess = session.getLastAccessedTime();
            }

            public void touchSession() {
                this.lastAccess = System.currentTimeMillis();
            }

            private boolean isExpired() {
                long maxInterval;
                long elapsedInterval = System.currentTimeMillis() - this.lastAccess;
                return elapsedInterval + 15000L > (maxInterval = (long)(this.session.getMaxInactiveInterval() * 1000));
            }

            private void shutdownIfExpired() {
                try {
                    if (this.isExpired()) {
                        sessionMonitors.remove(this.session);
                        Listener.this.sessionShutdown(this.session);
                    }
                }
                catch (IllegalStateException e) {
                }
                catch (Throwable t) {
                    Log.warn((Object)"Failed to monitor session expiry", t);
                }
            }
        }
    }
}

