/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.webapp.http.common.ResponseHandler;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.servlet.PseudoServlet;
import com.icesoft.faces.webapp.http.servlet.ServletRequestResponse;
import edu.emory.mathcs.backport.java.util.concurrent.Semaphore;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ThreadBlockingAdaptingServlet
implements PseudoServlet {
    private Server server;

    public ThreadBlockingAdaptingServlet(Server server) {
        this.server = server;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThreadBlockingRequestResponse requestResponse = new ThreadBlockingRequestResponse(request, response);
        this.server.service(requestResponse);
        requestResponse.blockUntilRespond();
    }

    public void shutdown() {
        this.server.shutdown();
    }

    private class ThreadBlockingRequestResponse
    extends ServletRequestResponse {
        private boolean blockResponse;
        private Semaphore semaphore;

        public ThreadBlockingRequestResponse(HttpServletRequest request, HttpServletResponse response) {
            super(request, response);
            this.blockResponse = true;
        }

        public void respondWith(ResponseHandler handler) throws Exception {
            super.respondWith(handler);
            if (this.semaphore == null) {
                this.blockResponse = false;
            } else {
                this.semaphore.release();
            }
        }

        public void blockUntilRespond() throws InterruptedException {
            if (this.blockResponse) {
                this.semaphore = new Semaphore(1);
                this.semaphore.acquire();
                this.semaphore.acquire();
                this.semaphore.release();
            }
        }
    }
}

