/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.webapp.http.core.ViewQueue;
import com.icesoft.faces.webapp.http.servlet.EventResponder;
import com.icesoft.faces.webapp.http.servlet.MainSessionBoundServlet;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.CometEvent;
import org.apache.catalina.CometProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TomcatPushServlet
extends HttpServlet
implements CometProcessor {
    private static Log log = LogFactory.getLog(TomcatPushServlet.class);

    public void init() throws ServletException {
    }

    public void destroy() {
    }

    public void event(CometEvent event) throws IOException, ServletException {
        HttpServletRequest request = event.getHttpServletRequest();
        HttpServletResponse response = event.getHttpServletResponse();
        if (event.getEventType() == CometEvent.EventType.BEGIN) {
            this.begin(event, request, response);
        } else if (event.getEventType() == CometEvent.EventType.ERROR) {
            this.error(event, request, response);
        } else if (event.getEventType() == CometEvent.EventType.END) {
            this.end(event, request, response);
        } else if (event.getEventType() == CometEvent.EventType.READ) {
            this.read(event, request, response);
        }
    }

    protected void begin(CometEvent event, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        MainSessionBoundServlet mainBound = (MainSessionBoundServlet)SessionDispatcher.getSingletonSessionServlet(request.getSession());
        ViewQueue allUpdatedViews = mainBound.getAllUpdatedViews();
        Collection synchronouslyUpdatedViews = mainBound.getSynchronouslyUpdatedViews();
        allUpdatedViews.onPut(new EventResponder(event, synchronouslyUpdatedViews, allUpdatedViews));
    }

    protected void end(CometEvent event, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        event.close();
    }

    protected void error(CometEvent event, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
    }

    protected void read(CometEvent event, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ServletInputStream is = request.getInputStream();
        byte[] buf = new byte[512];
        do {
            int n;
            if ((n = is.read(buf)) > 0) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Read " + n + " bytes: " + new String(buf, 0, n) + " for session: " + request.getSession(true).getId()));
                continue;
            }
            if (n >= 0) continue;
            this.error(event, request, response);
            return;
        } while (is.available() > 0);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        throw new ServletException("service() not supported by TomcatPushServlet");
    }
}

