/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.webapp.command.Command;
import com.icesoft.faces.webapp.command.SessionExpired;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.common.standard.FixedXMLContentHandler;
import com.icesoft.faces.webapp.http.servlet.BasicAdaptingServlet;
import com.icesoft.faces.webapp.http.servlet.ServletRequestResponse;
import com.icesoft.faces.webapp.http.servlet.ServletView;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.faces.FacesException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ViewBoundAdaptingServlet
extends BasicAdaptingServlet {
    private static final Command SessionExpired = new SessionExpired();
    private Map views;
    private SessionDispatcher.Listener.Monitor sessionMonitor;

    public ViewBoundAdaptingServlet(Server server, SessionDispatcher.Listener.Monitor sessionMonitor, Map views) {
        super(server);
        this.sessionMonitor = sessionMonitor;
        this.views = views;
    }

    public synchronized void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String viewNumber = request.getParameter("viewNumber");
        if (viewNumber == null) {
            response.sendError(500, "Cannot match view instance. 'viewNumber' parameter is missing.");
        } else {
            ServletView view = (ServletView)this.views.get(viewNumber);
            if (view == null) {
                new ServletRequestResponse(request, response).respondWith(new FixedXMLContentHandler(){

                    public void writeTo(Writer writer) throws IOException {
                        SessionExpired.serializeTo(writer);
                    }
                });
            } else {
                try {
                    view.updateOnXMLHttpRequest(request, response);
                    this.sessionMonitor.touchSession();
                    super.service(request, response);
                }
                catch (FacesException e) {
                    Throwable nestedException = e.getCause();
                    if (nestedException == null || nestedException instanceof Error) {
                        throw e;
                    }
                    throw (Exception)nestedException;
                }
                finally {
                    view.release();
                }
            }
        }
    }
}

