/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SeamUtilities {
    private static final Log log = LogFactory.getLog((Class)SeamUtilities.class);
    private static Class seamManagerClass;
    private static Class[] seamClassArgs;
    private static Object[] seamInstanceArgs;
    private static Class[] seamGetEncodeMethodArgs;
    private static Object[] seamEncodeMethodArgs;
    private static Object[] seamMethodNoArgs;
    private static Method seamConversationIdMethodInstance;
    private static Method seamLongRunningMethodInstance;
    private static Method seamAppendConversationMethodInstance;
    private static Method seamInstanceMethod;
    private static Method seamPageContextGetPrefixInstance;
    private static Method seamConversationIdParameterMethod;
    private static Object pageContextInstance;
    private static String conversationIdParameter;
    private static String conversationParentParameter;
    private static String seamVersion;
    private static Method seamVersionMethod;
    private static String SPRING_CLASS_NAME;
    private static boolean isSpringLoaded;
    private static ClassLoader seamDebugPhaseListenerClassLoader;

    public static boolean isSeamEnvironment() {
        return seamManagerClass != null;
    }

    public static boolean requiresSeamExpressionFactory() {
        return seamVersion.startsWith("1.2.1");
    }

    public static String encodeSeamConversationId(String uri, String viewId) {
        if (!SeamUtilities.isSeamEnvironment()) {
            return uri;
        }
        String cleanedUrl = uri;
        if (conversationIdParameter == null) {
            SeamUtilities.getConversationIdParameterName();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("SeamConversationURLParam: " + conversationIdParameter));
        }
        StringTokenizer st = new StringTokenizer(uri, "?&");
        StringBuffer builder = new StringBuffer();
        boolean first = true;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.indexOf(conversationIdParameter) > -1 || token.indexOf(conversationParentParameter) > -1 || token.indexOf("rvn") > -1) continue;
            builder.append(token);
            if (!st.hasMoreTokens()) continue;
            if (first) {
                builder.append('?');
                first = false;
                continue;
            }
            builder.append('&');
        }
        if (builder.length() > 0) {
            cleanedUrl = builder.toString();
        }
        try {
            Object seamManagerInstance = seamInstanceMethod.invoke(null, seamInstanceArgs);
            if (seamAppendConversationMethodInstance != null) {
                SeamUtilities.seamEncodeMethodArgs[0] = cleanedUrl;
                if (seamEncodeMethodArgs.length == 2) {
                    SeamUtilities.seamEncodeMethodArgs[1] = viewId;
                }
                cleanedUrl = (String)seamAppendConversationMethodInstance.invoke(seamManagerInstance, seamEncodeMethodArgs);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Enabled redirect from: " + uri + ", to: " + cleanedUrl));
                }
            }
        }
        catch (Exception e) {
            seamInstanceMethod = null;
            seamManagerClass = null;
            log.error((Object)"Exception encoding seam conversationId: ", (Throwable)e);
        }
        return cleanedUrl;
    }

    public static String getSeamConversationId() {
        if (!SeamUtilities.isSeamEnvironment()) {
            return null;
        }
        String returnVal = null;
        try {
            Object seamManagerInstance = seamInstanceMethod.invoke(null, seamMethodNoArgs);
            if (seamConversationIdMethodInstance != null) {
                String conversationId = (String)seamConversationIdMethodInstance.invoke(seamManagerInstance, seamMethodNoArgs);
                Boolean is = (Boolean)seamLongRunningMethodInstance.invoke(seamManagerInstance, seamMethodNoArgs);
                if (is.booleanValue()) {
                    returnVal = conversationId;
                }
            }
        }
        catch (Exception e) {
            seamInstanceMethod = null;
            seamManagerClass = null;
            log.error((Object)"Exception determining Seam ConversationId: ", (Throwable)e);
        }
        return returnVal;
    }

    public static String getPageContextKey() {
        String returnVal = "";
        if (!SeamUtilities.isSeamEnvironment()) {
            return returnVal;
        }
        try {
            if (seamConversationIdMethodInstance != null) {
                returnVal = (String)seamPageContextGetPrefixInstance.invoke(pageContextInstance, seamMethodNoArgs);
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception fetching Page from ScopeType: ", (Throwable)e);
        }
        return returnVal;
    }

    private static void loadSeamEnvironment() {
        try {
            seamManagerClass = Class.forName("org.jboss.seam.core.Manager");
            Class<?> seamScopeTypeClass = Class.forName("org.jboss.seam.ScopeType");
            seamInstanceMethod = seamManagerClass.getMethod("instance", seamClassArgs);
            Field fieldInstance = seamScopeTypeClass.getField("PAGE");
            pageContextInstance = fieldInstance.get(seamScopeTypeClass);
            seamPageContextGetPrefixInstance = seamScopeTypeClass.getMethod("getPrefix", seamClassArgs);
            try {
                Class<?> seamClass = Class.forName("org.jboss.seam.Seam");
                seamVersionMethod = seamClass.getMethod("getVersion", null);
                if (seamVersionMethod != null) {
                    seamVersion = (String)seamVersionMethod.invoke(null, seamMethodNoArgs);
                    log.info((Object)("SeamUtilities: loadSeam.. seamVersion=" + seamVersion));
                }
            }
            catch (NoSuchMethodException e) {
                seamVersion = "1.2.1.GA";
                log.info((Object)"\t -->>>> seamVersion is null");
            }
            log.info((Object)("\t ->>> seamVersion=" + seamVersion));
            try {
                seamAppendConversationMethodInstance = seamManagerClass.getMethod("encodeConversationId", seamGetEncodeMethodArgs);
            }
            catch (NoSuchMethodException e) {
                seamGetEncodeMethodArgs = new Class[]{String.class};
                seamEncodeMethodArgs = new Object[1];
                seamAppendConversationMethodInstance = seamManagerClass.getMethod("encodeConversationId", seamGetEncodeMethodArgs);
            }
            seamConversationIdMethodInstance = seamManagerClass.getMethod("getCurrentConversationId", seamClassArgs);
            seamLongRunningMethodInstance = seamManagerClass.getMethod("isLongRunningConversation", seamClassArgs);
            seamConversationIdParameterMethod = seamManagerClass.getMethod("getConversationIdParameter", seamClassArgs);
            Class.forName("org.jboss.seam.util.Parameters");
        }
        catch (ClassNotFoundException cnf) {
        }
        catch (Exception e) {
            seamInstanceMethod = null;
            seamManagerClass = null;
            log.info((Object)"Exception loading seam environment: ", (Throwable)e);
        }
        if (seamManagerClass != null) {
            log.info((Object)"Seam environment detected ");
        }
    }

    public static String getConversationIdParameterName() {
        if (!SeamUtilities.isSeamEnvironment()) {
            return null;
        }
        if (conversationIdParameter != null) {
            return conversationIdParameter;
        }
        String returnVal = null;
        try {
            Object seamManagerInstance = seamInstanceMethod.invoke(null, seamMethodNoArgs);
            if (seamConversationIdParameterMethod != null) {
                conversationIdParameter = returnVal = (String)seamConversationIdParameterMethod.invoke(seamManagerInstance, seamMethodNoArgs);
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception fetching conversationId Parameter name: ", (Throwable)e);
        }
        return returnVal;
    }

    public static void removeSeamDebugPhaseListener(Lifecycle lifecycle) {
        PhaseListener[] phaseListeners = lifecycle.getPhaseListeners();
        for (int i = 0; i < phaseListeners.length; ++i) {
            if (!phaseListeners[i].getClass().getName().equals("org.jboss.seam.debug.jsf.SeamDebugPhaseListener")) continue;
            lifecycle.removePhaseListener(phaseListeners[i]);
            seamDebugPhaseListenerClassLoader = phaseListeners[i].getClass().getClassLoader();
        }
    }

    public static ClassLoader getSeamDebugPhaseListenerClassLoader() {
        return seamDebugPhaseListenerClassLoader;
    }

    private static void loadSpringEnvironment() {
        Class<?> flowVariableResolver;
        block4: {
            flowVariableResolver = null;
            try {
                flowVariableResolver = Class.forName(SPRING_CLASS_NAME);
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)("Spring webflow not detected: " + t));
            }
        }
        if (null != flowVariableResolver) {
            isSpringLoaded = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Spring webflow detected: " + flowVariableResolver));
            }
        }
    }

    public static boolean isSpringEnvironment() {
        return isSpringLoaded;
    }

    public static String getSpringFlowId() {
        if (!SeamUtilities.isSpringEnvironment()) {
            return null;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Object value = facesContext.getApplication().createValueBinding("#{flowExecutionKey}").getValue(facesContext);
        if (null == value) {
            return null;
        }
        return value.toString();
    }

    public static String getFlowIdParameterName() {
        return "_flowExecutionKey";
    }

    static {
        seamClassArgs = new Class[0];
        seamInstanceArgs = new Object[0];
        seamGetEncodeMethodArgs = new Class[]{String.class, String.class};
        seamEncodeMethodArgs = new Object[2];
        seamMethodNoArgs = new Object[0];
        conversationParentParameter = "parentConversationId";
        seamVersion = "none";
        SPRING_CLASS_NAME = "org.springframework.webflow.executor.jsf.FlowVariableResolver";
        SeamUtilities.loadSeamEnvironment();
        SeamUtilities.loadSpringEnvironment();
    }
}

