/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.async.render;

import com.icesoft.faces.async.render.AsyncRenderer;
import com.icesoft.faces.async.render.ContextDestroyedListener;
import com.icesoft.faces.async.render.DelayRenderer;
import com.icesoft.faces.async.render.Disposable;
import com.icesoft.faces.async.render.IntervalRenderer;
import com.icesoft.faces.async.render.OnDemandRenderer;
import com.icesoft.faces.async.render.RenderHub;
import com.icesoft.faces.async.render.Renderable;
import com.icesoft.faces.util.event.servlet.ContextEventRepeater;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RenderManager
implements Disposable {
    private static Log log = LogFactory.getLog((Class)RenderManager.class);
    static final int MIN = 1;
    public static final int ON_DEMAND = 2;
    public static final int INTERVAL = 3;
    public static final int DELAY = 4;
    static final int MAX = 4;
    private RenderHub renderHub;
    private Map groupMap;
    private ContextDestroyedListener shutdownListener = new ContextDestroyedListener(this);

    public RenderManager() {
        ContextEventRepeater.addListener(this.shutdownListener);
        this.groupMap = Collections.synchronizedMap(new HashMap());
        this.renderHub = new RenderHub();
    }

    private synchronized AsyncRenderer getRenderer(String name, int type) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("illegal renderer name: " + name);
        }
        if (type < 1 || type > 4) {
            throw new IllegalArgumentException("illegal renderer type: " + type);
        }
        Object obj = this.groupMap.get(name);
        if (obj != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("existing renderer retrieved: " + name));
            }
            return (AsyncRenderer)obj;
        }
        AsyncRenderer renderer = null;
        switch (type) {
            case 2: {
                renderer = new OnDemandRenderer();
                break;
            }
            case 3: {
                renderer = new IntervalRenderer();
                break;
            }
            case 4: {
                renderer = new DelayRenderer();
            }
        }
        renderer.setName(name);
        renderer.setRenderManager(this);
        this.groupMap.put(name, renderer);
        if (log.isTraceEnabled()) {
            log.trace((Object)("new renderer retrieved: " + name));
        }
        return renderer;
    }

    protected void removeRenderer(AsyncRenderer renderer) {
        if (renderer == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"renderer is null");
            }
            return;
        }
        Object removedRenderer = this.groupMap.remove(renderer.getName());
        if (removedRenderer == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("renderer " + renderer.getName() + " not found"));
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("renderer " + renderer.getName() + " removed"));
        }
    }

    public void requestRender(Renderable renderable) {
        this.renderHub.requestRender(renderable);
    }

    void relayRender(String rendererName) {
    }

    public OnDemandRenderer getOnDemandRenderer(String name) {
        return (OnDemandRenderer)this.getRenderer(name, 2);
    }

    public IntervalRenderer getIntervalRenderer(String name) {
        return (IntervalRenderer)this.getRenderer(name, 3);
    }

    public DelayRenderer getDelayRenderer(String name) {
        return (DelayRenderer)this.getRenderer(name, 4);
    }

    ScheduledThreadPoolExecutor getScheduledService() {
        return this.renderHub.getScheduledService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map map = this.groupMap;
        synchronized (map) {
            ArrayList renderList = new ArrayList(this.groupMap.size());
            renderList.addAll(this.groupMap.values());
            Iterator renderers = renderList.iterator();
            while (renderers.hasNext()) {
                AsyncRenderer renderer = (AsyncRenderer)renderers.next();
                renderer.dispose();
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("renderer disposed: " + renderer));
            }
            this.groupMap.clear();
        }
        this.renderHub.dispose();
        if (log.isDebugEnabled()) {
            log.debug((Object)"all renderers and hub have been disposed");
        }
    }

    public AsyncRenderer getRenderer(String rendererName) {
        if (rendererName == null) {
            return null;
        }
        return (AsyncRenderer)this.groupMap.get(rendererName);
    }
}

