/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context;

import com.icesoft.faces.application.D2DViewHandler;
import com.icesoft.faces.context.BridgeExternalContext;
import com.icesoft.faces.context.DOMResponseWriter;
import com.icesoft.faces.context.DOMSerializer;
import com.icesoft.faces.context.NormalModeSerializer;
import com.icesoft.faces.context.PushModeSerializer;
import com.icesoft.faces.el.ELContextImpl;
import com.icesoft.faces.webapp.command.CommandQueue;
import com.icesoft.faces.webapp.http.common.Configuration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.el.ELContext;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BridgeFacesContext
extends FacesContext {
    private static final Log log = LogFactory.getLog((Class)BridgeFacesContext.class);
    private Application application;
    private BridgeExternalContext externalContext;
    private HashMap faceMessages = new HashMap();
    private boolean renderResponse;
    private boolean responseComplete;
    private ResponseStream responseStream;
    private ResponseWriter responseWriter;
    private DOMSerializer domSerializer;
    private UIViewRoot viewRoot;
    private String iceFacesId;
    private String viewNumber;
    private CommandQueue commandQueue;
    private Configuration configuration;

    public BridgeFacesContext(BridgeExternalContext externalContext, String view, String icefacesID, CommandQueue commandQueue, Configuration configuration) {
        BridgeFacesContext.setCurrentInstance((FacesContext)this);
        this.externalContext = externalContext;
        this.viewNumber = view;
        this.iceFacesId = icefacesID;
        this.commandQueue = commandQueue;
        this.configuration = configuration;
        this.application = ((ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory")).getApplication();
        this.externalContext = externalContext;
        this.switchToNormalMode();
    }

    public void setCurrentInstance() {
        BridgeFacesContext.setCurrentInstance((FacesContext)this);
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public Iterator getClientIdsWithMessages() {
        return this.faceMessages.keySet().iterator();
    }

    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    public void setExternalContext(ExternalContext externalContext) {
    }

    public ELContext getELContext() {
        ELContextImpl elContext = new ELContextImpl(this.application);
        elContext.putContext(FacesContext.class, (Object)this);
        UIViewRoot root = this.getViewRoot();
        if (null != root) {
            elContext.setLocale(root.getLocale());
        }
        return elContext;
    }

    public FacesMessage.Severity getMaximumSeverity() {
        throw new UnsupportedOperationException();
    }

    public Iterator getMessages() {
        ArrayList buffer = new ArrayList();
        Iterator i = this.faceMessages.values().iterator();
        while (i.hasNext()) {
            buffer.addAll((Vector)i.next());
        }
        return buffer.iterator();
    }

    public Iterator getMessages(String clientId) {
        try {
            return ((Vector)this.faceMessages.get(clientId)).iterator();
        }
        catch (NullPointerException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot find clientId " + clientId + "from facesMessages"));
            }
            return Collections.EMPTY_LIST.iterator();
        }
    }

    public RenderKit getRenderKit() {
        UIViewRoot viewRoot = this.getViewRoot();
        if (null == viewRoot) {
            return null;
        }
        String renderKitId = viewRoot.getRenderKitId();
        if (null == renderKitId) {
            return null;
        }
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = renderKitFactory.getRenderKit((FacesContext)this, renderKitId);
        return renderKit;
    }

    public boolean getRenderResponse() {
        return this.renderResponse;
    }

    public boolean getResponseComplete() {
        return this.responseComplete;
    }

    public ResponseStream getResponseStream() {
        return this.responseStream;
    }

    public void setResponseStream(ResponseStream responseStream) {
        this.responseStream = responseStream;
    }

    public ResponseWriter getResponseWriter() {
        return this.responseWriter;
    }

    public void setResponseWriter(ResponseWriter responseWriter) {
        this.responseWriter = responseWriter;
    }

    public ResponseWriter createAndSetResponseWriter() throws IOException {
        this.responseWriter = new DOMResponseWriter(this, this.domSerializer, this.configuration);
        return this.responseWriter;
    }

    public void switchToNormalMode() {
        try {
            this.domSerializer = new NormalModeSerializer(this, this.externalContext.getWriter("UTF-8"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void switchToPushMode() {
        if (this.responseWriter != null) {
            Document document = ((DOMResponseWriter)this.responseWriter).getDocument();
            this.domSerializer = new PushModeSerializer(document, this.commandQueue);
        }
    }

    public UIViewRoot getViewRoot() {
        Map contextServletTable;
        if (null == this.viewRoot && null != (contextServletTable = D2DViewHandler.getContextServletTable(this))) {
            this.viewRoot = (UIViewRoot)contextServletTable.get("com.icesoft.domResponseViewRoot");
        }
        return this.viewRoot;
    }

    public void setViewRoot(UIViewRoot viewRoot) {
        Map contextServletTable = D2DViewHandler.getContextServletTable(this);
        if (null != contextServletTable) {
            if (viewRoot != null) {
                contextServletTable.put("com.icesoft.domResponseViewRoot", viewRoot);
            } else {
                contextServletTable.remove("com.icesoft.domResponseViewRoot");
            }
        }
        this.responseWriter = null;
        this.viewRoot = viewRoot;
    }

    public String getIceFacesId() {
        return this.iceFacesId;
    }

    public String getViewNumber() {
        return this.viewNumber;
    }

    public String getFocusId() {
        Map map = this.externalContext.getRequestParameterMap();
        return map.containsKey("focus") ? map.get("focus") : "";
    }

    public void setFocusId(String focusId) {
        this.externalContext.getRequestParameterMap().put("focus", focusId);
    }

    public void addMessage(String clientId, FacesMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("Message is null");
        }
        if (this.faceMessages.containsKey(clientId)) {
            ((Vector)this.faceMessages.get(clientId)).addElement(message);
        } else {
            Vector<FacesMessage> vector = new Vector<FacesMessage>();
            vector.add(message);
            this.faceMessages.put(clientId, vector);
        }
    }

    public void renderResponse() {
        this.renderResponse = true;
    }

    public void responseComplete() {
        this.responseComplete = true;
    }

    public void resetRenderResponse() {
        this.renderResponse = false;
    }

    public void release() {
        this.faceMessages.clear();
        this.renderResponse = false;
        this.responseComplete = false;
        BridgeFacesContext.setCurrentInstance(null);
    }

    public void dispose() {
        String key = this.viewNumber + "/" + "com.icesoft.faces.sessionAuxiliaryData";
        this.externalContext.getSessionMap().remove(key);
    }

    public void applyBrowserDOMChanges() {
        if (this.responseWriter == null) {
            return;
        }
        Document document = ((DOMResponseWriter)this.responseWriter).getDocument();
        if (document == null) {
            return;
        }
        Map parameters = this.externalContext.getRequestParameterValuesMap();
        NodeList inputElements = document.getElementsByTagName("input");
        int inputElementsLength = inputElements.getLength();
        for (int i = 0; i < inputElementsLength; ++i) {
            Element inputElement = (Element)inputElements.item(i);
            String id = inputElement.getAttribute("id");
            if ("".equals(id) || !parameters.containsKey(id)) continue;
            String value = ((String[])parameters.get(id))[0];
            inputElement.setAttribute("value", value);
        }
        NodeList textareaElements = document.getElementsByTagName("textarea");
        int textareaElementsLength = textareaElements.getLength();
        for (int i = 0; i < textareaElementsLength; ++i) {
            Element textareaElement = (Element)textareaElements.item(i);
            String id = textareaElement.getAttribute("id");
            if ("".equals(id) || !parameters.containsKey(id)) continue;
            String value = ((String[])parameters.get(id))[0];
            textareaElement.getFirstChild().setNodeValue(value);
        }
        NodeList selectElements = document.getElementsByTagName("select");
        int selectElementsLength = selectElements.getLength();
        for (int i = 0; i < selectElementsLength; ++i) {
            Element selectElement = (Element)selectElements.item(i);
            String id = selectElement.getAttribute("id");
            if ("".equals(id) || !parameters.containsKey(id)) continue;
            List<String> values = Arrays.asList((String[])parameters.get(id));
            NodeList optionElements = selectElement.getElementsByTagName("option");
            int optionElementsLength = optionElements.getLength();
            for (int j = 0; j < optionElementsLength; ++j) {
                Element optionElement = (Element)optionElements.item(j);
                if (values.contains(optionElement.getAttribute("value"))) {
                    optionElement.setAttribute("selected", "selected");
                    continue;
                }
                optionElement.removeAttribute("selected");
            }
        }
    }
}

