/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context;

import java.io.Serializable;
import java.util.Map;
import java.util.Random;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ElementController
implements Serializable {
    private static final transient Random RANDOM = new Random();
    private transient String focusCode = "";
    private transient String selectCode = "";
    private transient String clickCode = "";

    public static ElementController from(Map session) {
        String key = ElementController.class.toString();
        if (!session.containsKey(key)) {
            session.put(key, new ElementController());
        }
        return (ElementController)session.get(key);
    }

    public void focus(String elementID) {
        this.focusCode = "'" + elementID + "'.asExtendedElement().focus();" + this.randomComment();
    }

    public void select(String elementID) {
        this.selectCode = "'" + elementID + "'.asExtendedElement().select();" + this.randomComment();
    }

    public void click(String elementID) {
        this.clickCode = "'" + elementID + "'.asExtendedElement().click();" + this.randomComment();
    }

    private String randomComment() {
        return "//" + RANDOM.nextInt(99999);
    }

    public void addInto(Element element) {
        Document document = element.getOwnerDocument();
        Element focusElement = (Element)element.appendChild(document.createElement("script"));
        focusElement.setAttribute("id", "focus-code");
        focusElement.appendChild(document.createTextNode(this.focusCode));
        Element selectElement = (Element)element.appendChild(document.createElement("script"));
        selectElement.setAttribute("id", "select-code");
        selectElement.appendChild(document.createTextNode(this.selectCode));
        Element clickElement = (Element)element.appendChild(document.createElement("script"));
        clickElement.setAttribute("id", "click-code");
        clickElement.appendChild(document.createTextNode(this.clickCode));
    }
}

