/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context;

import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.context.DOMSerializer;
import com.icesoft.faces.context.JAXPSerializer;
import com.icesoft.faces.context.effects.JavascriptContext;
import com.icesoft.faces.util.CoreUtils;
import com.icesoft.faces.util.DOMUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class NormalModeSerializer
implements DOMSerializer {
    private static Log log = LogFactory.getLog((Class)NormalModeSerializer.class);
    private BridgeFacesContext context;
    private Writer writer;

    public NormalModeSerializer(BridgeFacesContext context, Writer writer) {
        this.context = context;
        this.writer = writer;
    }

    public void serialize(Document document) throws IOException {
        Map requestMap = this.context.getExternalContext().getRequestMap();
        if (this.isFragment(requestMap)) {
            Node body;
            if (log.isDebugEnabled()) {
                log.debug((Object)"treating request as a fragment");
            }
            if (null != (body = DOMUtils.getChildByNodeName(document.getDocumentElement(), "body"))) {
                this.writer.write(this.makeScriptEntry(JavascriptContext.ICE_BRIDGE));
                this.writer.write(this.makeScriptEntry(JavascriptContext.ICE_EXTRAS));
                this.writer.write(DOMUtils.childrenToString(body));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"treating request as a whole page (not a fragment)");
            }
            String publicID = (String)requestMap.get("com.icesoft.doctype.public");
            String systemID = (String)requestMap.get("com.icesoft.doctype.system");
            String root = (String)requestMap.get("com.icesoft.doctype.root");
            String output = (String)requestMap.get("com.icesoft.doctype.output");
            boolean prettyPrinting = Boolean.valueOf((String)requestMap.get("com.icesoft.doctype.prettyprinting"));
            if (output == null || "html".equals(output) && !prettyPrinting) {
                if (publicID != null && systemID != null && root != null) {
                    this.writer.write(DOMUtils.DocumentTypetoString(publicID, systemID, root));
                }
                this.writer.write(DOMUtils.DOMtoString(document));
            } else {
                JAXPSerializer serializer = new JAXPSerializer(this.writer, publicID, systemID);
                if ("xml".equals(output)) {
                    serializer.outputAsXML();
                } else {
                    serializer.outputAsHTML();
                }
                if (prettyPrinting) {
                    serializer.printPretty();
                }
                serializer.serialize(document);
            }
        }
        this.writer.flush();
    }

    private String makeScriptEntry(String src) {
        return "<script language='javascript' src='" + CoreUtils.resolveResourceURL(this.context, src) + "'></script>";
    }

    private boolean isFragment(Map requestMap) {
        String frag = (String)requestMap.get("javax.servlet.include.request_uri");
        if (log.isDebugEnabled()) {
            log.debug((Object)("javax.servlet.include.request_uri = " + frag));
        }
        if (frag != null) {
            return true;
        }
        frag = (String)requestMap.get("javax.servlet.include.servlet_path");
        if (log.isDebugEnabled()) {
            log.debug((Object)("javax.servlet.include.servlet_path = " + frag));
        }
        if (frag != null) {
            return true;
        }
        frag = (String)requestMap.get("com.sun.faces.portlet.INIT");
        return frag != null;
    }
}

