/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.context.effects.JavascriptContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.w3c.dom.Element;

public class ButtonRenderer
extends DomBasicRenderer {
    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        this.validateParameters(facesContext, uiComponent, UICommand.class);
        if (ButtonRenderer.isStatic(uiComponent)) {
            return;
        }
        boolean thisButtonInvokedSubmit = this.didThisButtonInvokeSubmit(facesContext, uiComponent);
        if (!thisButtonInvokedSubmit) {
            return;
        }
        String type = ((String)uiComponent.getAttributes().get("type")).toLowerCase();
        if (type != null && type.equals("reset")) {
            return;
        }
        ActionEvent actionEvent = new ActionEvent(uiComponent);
        uiComponent.queueEvent((FacesEvent)actionEvent);
    }

    private boolean didThisButtonInvokeSubmit(FacesContext facesContext, UIComponent uiComponent) {
        boolean thisButtonInvokedSubmit = false;
        if (!this.isTextFieldInvokedSubmit(facesContext)) {
            String componentClientId;
            Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
            String clientIdInRequestMap = (String)requestParameterMap.get(componentClientId = uiComponent.getClientId(facesContext));
            boolean bl = thisButtonInvokedSubmit = clientIdInRequestMap != null;
            if (!thisButtonInvokedSubmit) {
                String clientIdXCoordinateInRequestMap = componentClientId + ".x";
                String clientIdYCoordinateInRequestMap = componentClientId + ".y";
                if (requestParameterMap.get(componentClientId + ".x") != null || requestParameterMap.get(componentClientId + ".y") != null) {
                    thisButtonInvokedSubmit = true;
                }
            }
        }
        return thisButtonInvokedSubmit;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Element root;
        this.validateParameters(facesContext, uiComponent, UICommand.class);
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        String clientId = uiComponent.getClientId(facesContext);
        if (!domContext.isInitialized()) {
            root = domContext.createElement("input");
            domContext.setRootNode(root);
            root.setAttribute("name", clientId);
        }
        root = (Element)domContext.getRootNode();
        ButtonRenderer.setRootElementId(facesContext, root, uiComponent);
        String typeAttribute = ((String)uiComponent.getAttributes().get("type")).toLowerCase();
        if (typeAttribute == null || !typeAttribute.equals("reset") && !typeAttribute.equals("button")) {
            typeAttribute = "submit";
        }
        uiComponent.getAttributes().put("type", typeAttribute);
        String imageAttribute = (String)uiComponent.getAttributes().get("image");
        if (imageAttribute != null) {
            typeAttribute = "image";
            root.setAttribute("type", typeAttribute);
            String pathToImage = ButtonRenderer.getResourceURL(facesContext, imageAttribute);
            root.setAttribute("src", pathToImage);
            root.removeAttribute("value");
        } else {
            root.setAttribute("type", typeAttribute);
            String label = "";
            Object componentValue = ((UICommand)uiComponent).getValue();
            label = componentValue != null ? componentValue.toString() : "";
            root.setAttribute("value", label);
            root.removeAttribute("src");
        }
        String styleClass = (String)uiComponent.getAttributes().get("styleClass");
        if (styleClass != null) {
            root.setAttribute("class", styleClass);
        }
        JavascriptContext.fireEffect(uiComponent, facesContext);
        PassThruAttributeRenderer.renderAttributes(facesContext, uiComponent, null);
        if (typeAttribute.equals("submit") || typeAttribute.equals("image")) {
            this.renderOnClick(uiComponent, root);
        }
        domContext.stepOver();
        domContext.streamWrite(facesContext, uiComponent);
    }

    protected void renderOnClick(UIComponent uiComponent, Element root) {
        String onclick = (String)uiComponent.getAttributes().get("onclick");
        StringBuffer stringBuffer = new StringBuffer();
        ((Object)((Object)this)).getClass();
        String submitCode = stringBuffer.append("iceSubmit(form,this,event);").append("return false;").toString();
        onclick = onclick == null ? submitCode : onclick + submitCode;
        root.setAttribute("onclick", onclick);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, UICommand.class);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, UICommand.class);
    }

    private boolean isTextFieldInvokedSubmit(FacesContext facesContext) {
        Object textFieldfocus = facesContext.getExternalContext().getRequestParameterMap().get("focus_hidden_field");
        if (textFieldfocus == null) {
            return false;
        }
        return textFieldfocus.toString().length() > 0;
    }
}

