/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.context.effects.CurrentStyle;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import com.icesoft.util.SeamUtilities;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class FormRenderer
extends DomBasicRenderer {
    public static final String COMMAND_LINK_HIDDEN_FIELD = "command_link_hidden_field";
    private static final String COMMAND_LINK_HIDDEN_FIELDS_KEY = "com.icesoft.faces.FormRequiredHidden";
    public static final String FOCUS_HIDDEN_FIELD = "focus_hidden_field";
    public static final String VIEWNUMBER_HIDDEN_FIELD = "viewNumber";
    private static final Log log = LogFactory.getLog((Class)FormRenderer.class);

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        this.validateParameters(facesContext, uiComponent, UIForm.class);
        UIForm uiForm = (UIForm)uiComponent;
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String formClientId = uiForm.getClientId(facesContext);
        if (requestParameterMap.containsKey(formClientId) || uiComponent.getAttributes().containsKey("fileUploaded")) {
            uiForm.setSubmitted(true);
        } else {
            uiForm.setSubmitted(false);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String flowId;
        Element root;
        this.validateParameters(facesContext, uiComponent, UIForm.class);
        this.validateNestingForm(uiComponent);
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        String formClientId = uiComponent.getClientId(facesContext);
        if (!domContext.isInitialized()) {
            String acceptcharset;
            root = domContext.createElement("form");
            domContext.setRootNode(root);
            root.setAttribute("id", formClientId);
            root.setAttribute("method", "post");
            String action = null;
            action = "iceSubmit('" + formClientId + "');";
            root.setAttribute("action", action);
            String styleClass = (String)uiComponent.getAttributes().get("styleClass");
            if (styleClass != null) {
                root.setAttribute("class", styleClass);
            }
            if ((acceptcharset = (String)uiComponent.getAttributes().get("acceptcharset")) != null) {
                root.setAttribute("accept-charset", acceptcharset);
            }
            String redirectScript = "'" + formClientId + "'.asExtendedElement().captureAndRedirectSubmit();";
            Element scriptElement = (Element)root.appendChild(domContext.createElement("script"));
            scriptElement.setAttribute("language", "javascript");
            scriptElement.appendChild(domContext.createTextNode(redirectScript));
            root.appendChild(scriptElement);
            Element formHiddenField = domContext.createElement("input");
            formHiddenField.setAttribute("type", "hidden");
            formHiddenField.setAttribute("name", formClientId);
            formHiddenField.setAttribute("value", formClientId);
            root.appendChild(formHiddenField);
            Element cssUpdateField = domContext.createElement("input");
            cssUpdateField.setAttribute("type", "hidden");
            cssUpdateField.setAttribute("name", CurrentStyle.CSS_UPDATE_FIELD);
            cssUpdateField.setAttribute("value", "");
            root.appendChild(cssUpdateField);
            if (!domContext.isStreamWriting()) {
                Element viewNumberElement = domContext.createElement("input");
                viewNumberElement.setAttribute("type", "hidden");
                viewNumberElement.setAttribute("name", VIEWNUMBER_HIDDEN_FIELD);
                viewNumberElement.setAttribute("value", ((BridgeFacesContext)facesContext).getViewNumber());
                root.appendChild(viewNumberElement);
            }
        }
        root = (Element)domContext.getRootNode();
        String conversationId = SeamUtilities.getSeamConversationId();
        if (conversationId != null) {
            String conversationParamName = SeamUtilities.getConversationIdParameterName();
            Element conversationIDElement = domContext.createElement("input");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Embedding Seam Param - name: " + conversationParamName + ", value: " + conversationId));
            }
            conversationIDElement.setAttribute("type", "hidden");
            conversationIDElement.setAttribute("name", conversationParamName);
            conversationIDElement.setAttribute("value", conversationId);
            root.appendChild(conversationIDElement);
        }
        if ((flowId = SeamUtilities.getSpringFlowId()) != null) {
            String flowParamName = SeamUtilities.getFlowIdParameterName();
            Element flowIDElement = domContext.createElement("input");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Embedding Spring Param - name: " + flowParamName + ", value: " + flowId));
            }
            String flowParamId = formClientId + ":" + flowParamName;
            flowIDElement.setAttribute("type", "hidden");
            flowIDElement.setAttribute("name", flowParamName);
            flowIDElement.setAttribute("id", flowParamId);
            flowIDElement.setAttribute("value", flowId);
            root.appendChild(flowIDElement);
        }
        String contextClass = facesContext.getClass().toString();
        root.setAttribute("context_type", contextClass);
        PassThruAttributeRenderer.renderAttributes(facesContext, uiComponent, null);
        facesContext.getApplication().getViewHandler().writeState(facesContext);
        String userDefinedValue = root.getAttribute("onsubmit");
        if (userDefinedValue == null || userDefinedValue.equalsIgnoreCase("")) {
            root.setAttribute("onsubmit", "return false;");
        }
        FormRenderer.addHiddenField(facesContext, FOCUS_HIDDEN_FIELD);
        try {
            domContext.startNode(facesContext, uiComponent, root);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        domContext.stepInto(uiComponent);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) {
        this.validateParameters(facesContext, uiComponent, UIForm.class);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, UIForm.class);
        DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
        FormRenderer.renderCommandLinkHiddenFields(facesContext, uiComponent);
        domContext.stepOver();
        domContext.endNode(facesContext, uiComponent, domContext.getRootNode());
    }

    private static void renderCommandLinkHiddenFields(FacesContext facesContext, UIComponent uiComponent) {
        Map commandLinkHiddenFields = FormRenderer.getCommandLinkFields(facesContext);
        if (commandLinkHiddenFields != null) {
            FormRenderer.renderRequiredCommandLinkHiddenFields(uiComponent, facesContext, commandLinkHiddenFields);
            FormRenderer.resetCommandLinkFieldsInRequestMap(facesContext);
        }
    }

    private static void resetCommandLinkFieldsInRequestMap(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        requestMap.put(COMMAND_LINK_HIDDEN_FIELDS_KEY, null);
    }

    private static void renderRequiredCommandLinkHiddenFields(UIComponent uiComponent, FacesContext facesContext, Map map) {
        DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
        Element root = (Element)domContext.getRootNode();
        Iterator commandLinkFields = map.entrySet().iterator();
        while (commandLinkFields.hasNext()) {
            Map.Entry nextField = commandLinkFields.next();
            if (!COMMAND_LINK_HIDDEN_FIELD.equals(nextField.getValue())) continue;
            Element next = domContext.createElement("input");
            next.setAttribute("type", "hidden");
            next.setAttribute("name", nextField.getKey().toString());
            root.appendChild(next);
        }
    }

    public static void addHiddenField(FacesContext facesContext, String fieldName) {
        FormRenderer.addHiddenField(facesContext, fieldName, COMMAND_LINK_HIDDEN_FIELD);
    }

    private static void addHiddenField(FacesContext facesContext, String fieldName, String value) {
        Map hiddenFieldMap = FormRenderer.getCommandLinkFields(facesContext);
        if (hiddenFieldMap == null) {
            hiddenFieldMap = FormRenderer.createCommandLinkFieldsOnRequestMap(facesContext);
        }
        if (!hiddenFieldMap.containsKey(fieldName)) {
            hiddenFieldMap.put(fieldName, value);
        }
    }

    private static Map getCommandLinkFields(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        HashMap hiddenFieldMap = (HashMap)requestMap.get(COMMAND_LINK_HIDDEN_FIELDS_KEY);
        if (hiddenFieldMap == null) {
            hiddenFieldMap = new HashMap();
            requestMap.put(COMMAND_LINK_HIDDEN_FIELDS_KEY, hiddenFieldMap);
        }
        return hiddenFieldMap;
    }

    private static Map createCommandLinkFieldsOnRequestMap(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        HashMap hiddenFieldMap = (HashMap)requestMap.get(COMMAND_LINK_HIDDEN_FIELDS_KEY);
        if (hiddenFieldMap == null) {
            hiddenFieldMap = new HashMap();
            requestMap.put(COMMAND_LINK_HIDDEN_FIELDS_KEY, hiddenFieldMap);
        }
        return hiddenFieldMap;
    }

    private void validateNestingForm(UIComponent uiComponent) throws IOException {
        UIComponent parent = uiComponent.getParent();
        if (parent == null) {
            return;
        }
        if (parent instanceof UIForm) {
            throw new FacesException("Nested form found on the page. The form action element can not be nested");
        }
        this.validateNestingForm(parent);
    }
}

