/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.util.Debug;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessage;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class MessageRenderer
extends DomBasicRenderer {
    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, UIMessage.class);
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        if (domContext.isStreamWriting()) {
            this.writeStream(facesContext, uiComponent);
            return;
        }
        FacesMessage facesMessage = this.getSingleMessage(facesContext, (UIMessage)uiComponent);
        if (!domContext.isInitialized()) {
            Element span = domContext.createElement("span");
            domContext.setRootNode(span);
            MessageRenderer.setRootElementId(facesContext, span, uiComponent);
        }
        Element root = (Element)domContext.getRootNode();
        if (facesMessage == null) {
            if (root != null) {
                DOMContext.removeChildren(root);
                domContext.stepOver();
            }
            return;
        }
        DOMContext.removeChildren(root);
        String[] styleAndStyleClass = MessageRenderer.getStyleAndStyleClass(uiComponent, facesMessage);
        String style = styleAndStyleClass[0];
        String styleClass = styleAndStyleClass[1];
        if (styleClass != null) {
            root.setAttribute("class", styleClass);
        }
        if (style != null && style.length() > 0) {
            root.setAttribute("style", style);
        } else {
            root.removeAttribute("style");
        }
        boolean tooltip = this.getToolTipAttribute(uiComponent);
        String[] summaryAndDetail = this.getSummaryAndDetail(facesMessage);
        String summary = summaryAndDetail[0];
        String detail = summaryAndDetail[1];
        boolean showSummary = ((UIMessage)uiComponent).isShowSummary();
        boolean showDetail = ((UIMessage)uiComponent).isShowDetail();
        if (tooltip && showSummary && showDetail) {
            root.setAttribute("title", summary);
            Text textNode = domContext.getDocument().createTextNode(detail);
            root.appendChild(textNode);
        } else {
            Text textNode;
            if (showSummary) {
                textNode = domContext.getDocument().createTextNode(summary);
                root.appendChild(textNode);
            }
            if (showDetail) {
                textNode = domContext.getDocument().createTextNode(detail);
                root.appendChild(textNode);
            }
        }
        domContext.stepOver();
    }

    private void writeStream(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String sstyle;
        DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
        Element root = domContext.createRootElement("span");
        Text text = domContext.createTextNode("Message goes here");
        Object style = uiComponent.getAttributes().get("style");
        String string = sstyle = style == null ? null : style.toString();
        if (sstyle != null && sstyle.length() > 0) {
            root.setAttribute("style", sstyle);
        } else {
            root.removeAttribute("style");
        }
        root.appendChild(text);
        domContext.streamWrite(facesContext, uiComponent);
        domContext.stepOver();
    }

    private FacesMessage getSingleMessage(FacesContext facesContext, UIMessage uiMessage) {
        String forComponentId = uiMessage.getFor();
        Debug.assertTrue(forComponentId != null, "For component must not be null");
        Iterator messages = null;
        if (forComponentId.length() == 0) {
            messages = facesContext.getMessages(null);
        } else {
            UIComponent forComponent = MessageRenderer.findForComponent(facesContext, (UIComponent)uiMessage);
            if (forComponent != null) {
                messages = facesContext.getMessages(forComponent.getClientId(facesContext));
            }
        }
        if (messages == null || !messages.hasNext()) {
            return null;
        }
        FacesMessage firstMessage = (FacesMessage)messages.next();
        return firstMessage;
    }
}

