/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.common.standard;

import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.RequestProxy;
import com.icesoft.faces.webapp.http.common.Response;
import com.icesoft.faces.webapp.http.common.ResponseHandler;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.common.standard.NotModifiedHandler;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

public class CacheControlledServer
implements Server {
    private static final Date ExpirationDate = new Date(System.currentTimeMillis() + 2629743830L);
    private static final Collection cache = new HashSet();
    private static final Date StartupTime = new Date();
    private Server server;
    private boolean served;

    public CacheControlledServer(Server server) {
        this.server = server;
    }

    public void service(Request request) throws Exception {
        block7: {
            if (this.served) {
                if (cache.contains(request.getHeader("If-None-Match"))) {
                    request.respondWith(new NotModifiedHandler(ExpirationDate));
                } else {
                    try {
                        Date modifiedSince = request.getHeaderAsDate("If-Modified-Since");
                        if (StartupTime.getTime() - modifiedSince.getTime() > 1000L) {
                            this.server.service(new EnhancedRequest(request));
                            break block7;
                        }
                        request.respondWith(new NotModifiedHandler(ExpirationDate));
                    }
                    catch (Exception e) {
                        this.server.service(new EnhancedRequest(request));
                    }
                }
            } else {
                this.server.service(new EnhancedRequest(request));
                this.served = true;
            }
        }
    }

    public void shutdown() {
        cache.clear();
        this.served = false;
    }

    private class EnhancedRequest
    extends RequestProxy {
        public EnhancedRequest(Request request) {
            super(request);
        }

        public void respondWith(final ResponseHandler handler) throws Exception {
            this.request.respondWith(new ResponseHandler(){

                public void respond(Response response) throws Exception {
                    String eTag = String.valueOf(Math.abs(EnhancedRequest.this.request.getURI().hashCode()));
                    cache.add(eTag);
                    response.setHeader("ETag", eTag);
                    response.setHeader("Cache-Control", new String[]{"private", "max-age=86400"});
                    response.setHeader("Last-Modified", StartupTime);
                    handler.respond(response);
                }
            });
        }
    }
}

