/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.core;

import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Response;
import com.icesoft.faces.webapp.http.common.ResponseHandler;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.common.standard.FixedXMLContentHandler;
import com.icesoft.faces.webapp.http.core.ViewQueue;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;

public class SendUpdatedViews
implements Server {
    private static final Runnable Noop = new Runnable(){

        public void run() {
        }
    };
    private static final ResponseHandler EmptyResponseHandler = new ResponseHandler(){

        public void respond(Response response) throws Exception {
            response.setHeader("Content-Length", 0);
        }
    };
    private BlockingQueue pendingRequest = new LinkedBlockingQueue(1);
    private ViewQueue allUpdatedViews;

    public SendUpdatedViews(final Collection synchronouslyUpdatedViews, final ViewQueue allUpdatedViews) {
        this.allUpdatedViews = allUpdatedViews;
        this.allUpdatedViews.onPut(new Runnable(){

            public void run() {
                try {
                    Request request;
                    allUpdatedViews.removeAll(synchronouslyUpdatedViews);
                    synchronouslyUpdatedViews.clear();
                    HashSet viewIdentifiers = new HashSet(allUpdatedViews);
                    if (!viewIdentifiers.isEmpty() && (request = (Request)SendUpdatedViews.this.pendingRequest.poll()) != null) {
                        request.respondWith(new UpdatedViewsHandler(viewIdentifiers.toArray(new String[viewIdentifiers.size()])));
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void service(Request request) throws Exception {
        this.respondToPreviousRequest();
        this.pendingRequest.put((Object)request);
    }

    private void respondToPreviousRequest() {
        Request previousRequest = (Request)this.pendingRequest.poll();
        if (previousRequest != null) {
            try {
                previousRequest.respondWith(EmptyResponseHandler);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void shutdown() {
        this.allUpdatedViews.onPut(Noop);
        this.respondToPreviousRequest();
    }

    private class UpdatedViewsHandler
    extends FixedXMLContentHandler {
        private String[] viewIdentifiers;

        public UpdatedViewsHandler(String[] viewIdentifiers) {
            this.viewIdentifiers = viewIdentifiers;
        }

        public void writeTo(Writer writer) throws IOException {
            writer.write("<updated-views>");
            for (int i = 0; i < this.viewIdentifiers.length; ++i) {
                writer.write(this.viewIdentifiers[i]);
                writer.write(32);
            }
            writer.write("</updated-views>");
        }
    }
}

