/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.core;

import com.icesoft.faces.webapp.command.Command;
import com.icesoft.faces.webapp.command.CommandQueue;
import com.icesoft.faces.webapp.command.Macro;
import com.icesoft.faces.webapp.command.NOOP;
import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.common.standard.FixedXMLContentHandler;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class SendUpdates
implements Server {
    private static final Command NOOP = new NOOP();
    private Map commandQueues;

    public SendUpdates(Map commandQueues) {
        this.commandQueues = commandQueues;
    }

    public void service(Request request) throws Exception {
        request.respondWith(new Handler(this.commandQueues, request));
    }

    public void shutdown() {
    }

    public static class Handler
    extends FixedXMLContentHandler {
        private final Request request;
        private Map commandQueues;

        public Handler(Map commandQueues, Request request) {
            this.commandQueues = commandQueues;
            this.request = request;
        }

        public void writeTo(Writer writer) throws IOException {
            HashSet<String> viewIdentifierSet = new HashSet<String>(Arrays.asList(this.request.getParameterAsStrings("viewNumber")));
            Iterator<String> viewIdentifiers = viewIdentifierSet.iterator();
            ArrayList<Command> commandList = new ArrayList<Command>(viewIdentifierSet.size());
            while (viewIdentifiers.hasNext()) {
                String viewIdentifier = viewIdentifiers.next();
                if (!this.commandQueues.containsKey(viewIdentifier)) continue;
                CommandQueue queue = (CommandQueue)this.commandQueues.get(viewIdentifier);
                commandList.add(queue.take());
            }
            if (commandList.size() > 1) {
                Command[] commands = commandList.toArray(new Command[commandList.size()]);
                new Macro(commands).serializeTo(writer);
            } else if (commandList.size() == 1) {
                Command command = (Command)commandList.get(0);
                command.serializeTo(writer);
            } else {
                NOOP.serializeTo(writer);
            }
        }
    }
}

