/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.core.ViewQueue;
import com.icesoft.faces.webapp.http.servlet.ContinuationAdaptingServlet;
import com.icesoft.faces.webapp.http.servlet.PseudoServlet;
import com.icesoft.faces.webapp.http.servlet.ThreadBlockingAdaptingServlet;
import java.util.Collection;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EnvironmentAdaptingServlet
implements PseudoServlet {
    private static final Log LOG = LogFactory.getLog((Class)EnvironmentAdaptingServlet.class);
    private PseudoServlet servlet;

    public EnvironmentAdaptingServlet(Server server, Configuration configuration, String icefacesID, Collection synchronouslyUpdatedViews, ViewQueue allUpdatedViews, ServletContext servletContext) {
        boolean useJettyContinuationsByDefault;
        boolean useAsyncHttpServerByDefault;
        try {
            this.getClass().getClassLoader().loadClass("com.icesoft.faces.async.server.AsyncHttpServerAdaptingServlet");
            useAsyncHttpServerByDefault = true;
        }
        catch (ClassNotFoundException exception) {
            useAsyncHttpServerByDefault = false;
        }
        try {
            this.getClass().getClassLoader().loadClass("org.mortbay.util.ajax.Continuation");
            useJettyContinuationsByDefault = true;
        }
        catch (ClassNotFoundException e) {
            useJettyContinuationsByDefault = false;
        }
        if (configuration.getAttributeAsBoolean("useAsyncHttpServer", useAsyncHttpServerByDefault)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Adapting to Asynchronous HTTP Server environment.");
            }
            try {
                this.servlet = (PseudoServlet)this.getClass().getClassLoader().loadClass("com.icesoft.faces.async.server.AsyncHttpServerAdaptingServlet").getDeclaredConstructor(Server.class, String.class, Collection.class, ViewQueue.class, ServletContext.class).newInstance(new Object[]{server, icefacesID, synchronouslyUpdatedViews, allUpdatedViews, servletContext});
            }
            catch (Exception exception) {
                if (LOG.isFatalEnabled()) {
                    LOG.fatal((Object)"Failed to instantiate AsyncHttpServerAdaptingServlet!", (Throwable)exception);
                }
            }
        } else if (configuration.getAttributeAsBoolean("useJettyContinuations", useJettyContinuationsByDefault)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Adapting to Jetty's Continuation environment.");
            }
            this.servlet = new ContinuationAdaptingServlet(server);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Adapting to thread blocking environment.");
            }
            this.servlet = new ThreadBlockingAdaptingServlet(server);
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.servlet.service(request, response);
    }

    public void shutdown() {
        this.servlet.shutdown();
    }
}

