/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.webapp.http.core.ResourceServer;
import com.icesoft.faces.webapp.http.servlet.BasicAdaptingServlet;
import com.icesoft.faces.webapp.http.servlet.MainSessionBoundServlet;
import com.icesoft.faces.webapp.http.servlet.PathDispatcher;
import com.icesoft.faces.webapp.http.servlet.PseudoServlet;
import com.icesoft.faces.webapp.http.servlet.ServletContextConfiguration;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import com.icesoft.util.IdGenerator;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MainServlet
extends HttpServlet {
    private static Log log = LogFactory.getLog((Class)MainServlet.class);
    private PathDispatcher dispatcher = new PathDispatcher();
    private static final String AWT_HEADLESS = "java.awt.headless";

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            ServletContext servletContext = servletConfig.getServletContext();
            String awtHeadless = System.getProperty(AWT_HEADLESS);
            if (null == awtHeadless) {
                System.setProperty(AWT_HEADLESS, "true");
            }
            final ServletContextConfiguration configuration = new ServletContextConfiguration("com.icesoft.faces", servletContext);
            final IdGenerator idGenerator = this.getIdGenerator(servletContext);
            SessionDispatcher sessionServer = new SessionDispatcher(){

                protected PseudoServlet newServlet(HttpSession session, SessionDispatcher.Listener.Monitor sessionMonitor) {
                    return new MainSessionBoundServlet(session, sessionMonitor, idGenerator, configuration);
                }
            };
            BasicAdaptingServlet resourceServer = new BasicAdaptingServlet(new ResourceServer(configuration));
            this.dispatcher.dispatchOn(".*xmlhttp\\/.*", resourceServer);
            this.dispatcher.dispatchOn(".*", sessionServer);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private IdGenerator getIdGenerator(ServletContext servletContext) throws MalformedURLException {
        URL res = servletContext.getResource("/");
        if (res == null && (res = servletContext.getResource("/WEB-INF/web.xml")) == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"invalid resource path");
            }
            throw new NullPointerException("invalid resource path");
        }
        return new IdGenerator(res.getPath());
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)this.getIncludeInfo(request, "entering main servlet"));
        }
        request.setAttribute("servletkey", (Object)"persistent");
        try {
            this.dispatcher.service(request, response);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private String getIncludeInfo(HttpServletRequest req, String header) {
        StringBuffer buff = new StringBuffer(header);
        buff.append("\nvia Attributes - via Methods");
        buff.append("\n");
        buff.append("javax.servlet.include.context_path");
        buff.append(": ");
        buff.append(req.getAttribute("javax.servlet.include.context_path"));
        buff.append(" - ");
        buff.append(req.getContextPath());
        buff.append("\n");
        buff.append("javax.servlet.include.path_info");
        buff.append(": ");
        buff.append(req.getAttribute("javax.servlet.include.path_info"));
        buff.append(" - ");
        buff.append(req.getPathInfo());
        buff.append("\n");
        buff.append("javax.servlet.include.query_string");
        buff.append(": ");
        buff.append(req.getAttribute("javax.servlet.include.query_string"));
        buff.append(" - ");
        buff.append(req.getQueryString());
        buff.append("\n");
        buff.append("javax.servlet.include.request_uri");
        buff.append(": ");
        buff.append(req.getAttribute("javax.servlet.include.request_uri"));
        buff.append(" - ");
        buff.append(req.getRequestURI());
        buff.append("\n");
        buff.append("javax.servlet.include.servlet_path");
        buff.append(": ");
        buff.append(req.getAttribute("javax.servlet.include.servlet_path"));
        buff.append(" - ");
        buff.append(req.getServletPath());
        buff.append("\n\n");
        buff.append("via getAttributeNames():\n");
        Enumeration attrNames = req.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            String key = (String)attrNames.nextElement();
            Object val = req.getAttribute(key);
            buff.append("\t");
            buff.append(key);
            buff.append(": ");
            buff.append(val.toString());
            buff.append("\n");
        }
        return buff.toString();
    }

    public void destroy() {
        this.dispatcher.shutdown();
    }
}

