/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.util.event.servlet.ContextEventRepeater;
import com.icesoft.faces.webapp.command.CommandQueue;
import com.icesoft.faces.webapp.command.SessionExpired;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.core.DisposeViews;
import com.icesoft.faces.webapp.http.core.IDVerifier;
import com.icesoft.faces.webapp.http.core.ReceivePing;
import com.icesoft.faces.webapp.http.core.ReceiveSendUpdates;
import com.icesoft.faces.webapp.http.core.SendUpdatedViews;
import com.icesoft.faces.webapp.http.core.SendUpdates;
import com.icesoft.faces.webapp.http.core.ViewQueue;
import com.icesoft.faces.webapp.http.servlet.BasicAdaptingServlet;
import com.icesoft.faces.webapp.http.servlet.EnvironmentAdaptingServlet;
import com.icesoft.faces.webapp.http.servlet.MultiViewServlet;
import com.icesoft.faces.webapp.http.servlet.PathDispatcher;
import com.icesoft.faces.webapp.http.servlet.PseudoServlet;
import com.icesoft.faces.webapp.http.servlet.ServletView;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import com.icesoft.faces.webapp.http.servlet.SingleViewServlet;
import com.icesoft.faces.webapp.http.servlet.UploadServlet;
import com.icesoft.faces.webapp.http.servlet.ViewBoundAdaptingServlet;
import com.icesoft.util.IdGenerator;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MainSessionBoundServlet
implements PseudoServlet {
    private static final Log Log = LogFactory.getLog((Class)MainSessionBoundServlet.class);
    private static final SessionExpired SessionExpired = new SessionExpired();
    private static final PseudoServlet NOOPServlet = new PseudoServlet(){

        public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        }

        public void shutdown() {
        }
    };
    private Runnable drainUpdatedViews = new Runnable(){

        public void run() {
            MainSessionBoundServlet.this.allUpdatedViews.removeAll(MainSessionBoundServlet.this.synchronouslyUpdatedViews);
            if (!MainSessionBoundServlet.this.allUpdatedViews.isEmpty()) {
                Log.warn((Object)((Object)((Object)MainSessionBoundServlet.this.allUpdatedViews) + " views have accumulated updates"));
            }
            MainSessionBoundServlet.this.allUpdatedViews.clear();
        }
    };
    private PathDispatcher dispatcher = new PathDispatcher();
    private Map views = new HashMap();
    private ViewQueue allUpdatedViews = new ViewQueue();
    private Collection synchronouslyUpdatedViews = new HashSet();
    private HttpSession session;
    private String sessionID;

    public MainSessionBoundServlet(HttpSession session, SessionDispatcher.Listener.Monitor sessionMonitor, IdGenerator idGenerator, Configuration configuration) {
        PseudoServlet receivePing;
        PseudoServlet sendUpdates;
        PseudoServlet sendUpdatedViews;
        PseudoServlet disposeViews;
        BasicAdaptingServlet viewServlet;
        this.session = session;
        this.sessionID = idGenerator.newIdentifier();
        ContextEventRepeater.iceFacesIdRetrieved(this.session, this.sessionID);
        if (configuration.getAttributeAsBoolean("concurrentDOMViews", false)) {
            viewServlet = new MultiViewServlet(this.session, this.sessionID, sessionMonitor, this.views, this.allUpdatedViews, configuration);
            disposeViews = new BasicAdaptingServlet(new IDVerifier(this.sessionID, new DisposeViews(this.views)));
        } else {
            viewServlet = new SingleViewServlet(this.session, this.sessionID, sessionMonitor, this.views, this.allUpdatedViews, configuration);
            disposeViews = NOOPServlet;
        }
        if (configuration.getAttributeAsBoolean("synchronousUpdate", false)) {
            this.allUpdatedViews.onPut(this.drainUpdatedViews);
            sendUpdatedViews = NOOPServlet;
            sendUpdates = NOOPServlet;
            receivePing = NOOPServlet;
        } else {
            sendUpdatedViews = new EnvironmentAdaptingServlet(new IDVerifier(this.sessionID, new SendUpdatedViews(this.synchronouslyUpdatedViews, this.allUpdatedViews)), configuration, this.sessionID, this.synchronouslyUpdatedViews, this.allUpdatedViews, this.session.getServletContext());
            sendUpdates = new BasicAdaptingServlet(new IDVerifier(this.sessionID, new SendUpdates(this.views)));
            receivePing = new BasicAdaptingServlet(new IDVerifier(this.sessionID, new ReceivePing(this.views)));
        }
        UploadServlet upload = new UploadServlet(this.views, configuration, this.session.getServletContext());
        ViewBoundAdaptingServlet receiveSendUpdates = new ViewBoundAdaptingServlet(new IDVerifier(this.sessionID, new ReceiveSendUpdates(this.views, this.synchronouslyUpdatedViews)), sessionMonitor, this.views);
        this.dispatcher.dispatchOn(".*block\\/send\\-receive\\-updates$", receiveSendUpdates);
        this.dispatcher.dispatchOn(".*block\\/receive\\-updated\\-views$", sendUpdatedViews);
        this.dispatcher.dispatchOn(".*block\\/receive\\-updates$", sendUpdates);
        this.dispatcher.dispatchOn(".*block\\/ping$", receivePing);
        this.dispatcher.dispatchOn(".*block\\/dispose\\-views$", disposeViews);
        this.dispatcher.dispatchOn(".*uploadHtml", upload);
        this.dispatcher.dispatchOn(".*", viewServlet);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.dispatcher.service(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Iterator i = this.views.values().iterator();
        while (i.hasNext()) {
            CommandQueue commandQueue = (CommandQueue)i.next();
            commandQueue.put(SessionExpired);
        }
        ContextEventRepeater.iceFacesIdDisposed(this.session, this.sessionID);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
        }
        finally {
            this.dispatcher.shutdown();
        }
        Iterator viewIterator = this.views.values().iterator();
        while (viewIterator.hasNext()) {
            ServletView view = (ServletView)viewIterator.next();
            view.dispose();
        }
    }

    public ViewQueue getAllUpdatedViews() {
        return this.allUpdatedViews;
    }

    public Collection getSynchronouslyUpdatedViews() {
        return this.synchronouslyUpdatedViews;
    }
}

