/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.webapp.http.servlet.PseudoServlet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PathDispatcher
implements PseudoServlet {
    private static Log log = LogFactory.getLog((Class)PathDispatcher.class);
    private List matchers = new ArrayList();

    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String path = request.getRequestURI();
        if (log.isDebugEnabled()) {
            log.debug((Object)("path: " + path));
        }
        Iterator i = this.matchers.iterator();
        boolean matched = false;
        while (!matched && i.hasNext()) {
            matched = ((Matcher)i.next()).serviceOnMatch(path, request, response);
        }
        if (!matched) {
            response.sendError(404, "Resource at '" + path + "' not found.");
        }
    }

    public void dispatchOn(String pathExpression, PseudoServlet toServer) {
        this.matchers.add(new Matcher(pathExpression, toServer));
    }

    public void shutdown() {
        Iterator i = this.matchers.iterator();
        while (i.hasNext()) {
            Matcher matcher = (Matcher)i.next();
            matcher.shutdown();
        }
    }

    private class Matcher {
        private Pattern pattern;
        private PseudoServlet server;

        public Matcher(String expression, PseudoServlet server) {
            this.pattern = Pattern.compile(expression);
            this.server = server;
        }

        boolean serviceOnMatch(String path, HttpServletRequest request, HttpServletResponse response) throws Exception {
            if (this.pattern.matcher(path).find()) {
                this.server.service(request, response);
                return true;
            }
            return false;
        }

        void shutdown() {
            this.server.shutdown();
        }
    }
}

