/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.context.ViewListener;
import com.icesoft.faces.env.ServletEnvironmentRequest;
import com.icesoft.faces.webapp.command.Command;
import com.icesoft.faces.webapp.command.CommandQueue;
import com.icesoft.faces.webapp.command.NOOP;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.core.ViewQueue;
import com.icesoft.faces.webapp.http.servlet.ServletExternalContext;
import com.icesoft.faces.webapp.xmlhttp.PersistentFacesState;
import com.icesoft.util.SeamUtilities;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServletView
implements CommandQueue {
    private static final Log Log = LogFactory.getLog((Class)ServletView.class);
    private static final NOOP NOOP = new NOOP();
    private Lock lock = new ReentrantLock();
    private ServletExternalContext externalContext;
    private BridgeFacesContext facesContext;
    private PersistentFacesState persistentFacesState;
    private Map bundles = Collections.EMPTY_MAP;
    private ServletEnvironmentRequest wrappedRequest;
    private Command currentCommand = NOOP;
    private String viewIdentifier;
    private ArrayList onPutListeners = new ArrayList();
    private ArrayList onTakeListeners = new ArrayList();
    private Collection viewListeners = new ArrayList();
    private String sessionID;
    private Configuration configuration;

    public ServletView(final String viewIdentifier, String sessionID, HttpServletRequest request, HttpServletResponse response, final ViewQueue allServedViews, Configuration configuration) {
        this.wrappedRequest = new ServletEnvironmentRequest(request);
        this.sessionID = sessionID;
        this.configuration = configuration;
        this.viewIdentifier = viewIdentifier;
        this.externalContext = new ServletExternalContext(viewIdentifier, this.wrappedRequest, response, this, configuration);
        this.facesContext = new BridgeFacesContext(this.externalContext, viewIdentifier, sessionID, this, configuration);
        this.persistentFacesState = new PersistentFacesState(this.facesContext, this.viewListeners, configuration);
        this.onPut(new Runnable(){

            public void run() {
                try {
                    allServedViews.put(viewIdentifier);
                }
                catch (InterruptedException e) {
                    Log.warn((Object)"Failed to queue updated view", (Throwable)e);
                }
            }
        });
        this.notifyViewCreation();
    }

    public void updateOnXMLHttpRequest(HttpServletRequest request, HttpServletResponse response) {
        this.externalContext.update(request, response);
        this.makeCurrent();
    }

    public void updateOnRequest(HttpServletRequest request, HttpServletResponse response) {
        if (this.differentURI(request)) {
            this.redirectPage(request, response);
        } else {
            this.reloadPage(request, response);
        }
        this.makeCurrent();
    }

    public void switchToNormalMode() {
        this.facesContext.switchToNormalMode();
        this.externalContext.switchToNormalMode();
    }

    public void switchToPushMode() {
        this.bundles = this.externalContext.collectBundles();
        this.facesContext.switchToPushMode();
        this.externalContext.switchToPushMode();
    }

    public boolean differentURI(HttpServletRequest request) {
        return SeamUtilities.isSeamEnvironment() || !request.getRequestURI().equals(this.wrappedRequest.getRequestURI());
    }

    public void put(Command command) {
        this.lock.lock();
        this.currentCommand = this.currentCommand.coalesceWith(command);
        this.lock.unlock();
        this.broadcastTo(this.onPutListeners);
    }

    public Command take() {
        this.lock.lock();
        Command command = this.currentCommand;
        this.currentCommand = NOOP;
        this.lock.unlock();
        this.broadcastTo(this.onTakeListeners);
        return command;
    }

    public void onPut(Runnable listener) {
        this.onPutListeners.add(listener);
    }

    public void onTake(Runnable listener) {
        this.onTakeListeners.add(listener);
    }

    private void broadcastTo(Collection listeners) {
        Iterator i = listeners.iterator();
        while (i.hasNext()) {
            Runnable listener = (Runnable)i.next();
            try {
                listener.run();
            }
            catch (Exception e) {
                Log.error((Object)("Failed to notify listener: " + listener), (Throwable)e);
            }
        }
    }

    public void release() {
        this.facesContext.release();
        this.persistentFacesState.release();
        this.externalContext.resetRequestMap();
    }

    public BridgeFacesContext getFacesContext() {
        return this.facesContext;
    }

    public void dispose() {
        this.notifyViewDisposal();
        this.release();
        this.facesContext.dispose();
        this.externalContext.dispose();
    }

    private void redirectPage(HttpServletRequest request, HttpServletResponse response) {
        this.wrappedRequest = new ServletEnvironmentRequest(request);
        this.externalContext = new ServletExternalContext(this.viewIdentifier, this.wrappedRequest, response, this, this.configuration);
        this.facesContext = new BridgeFacesContext(this.externalContext, this.viewIdentifier, this.sessionID, this, this.configuration);
        this.persistentFacesState.setFacesContext(this.facesContext);
    }

    private void reloadPage(HttpServletRequest request, HttpServletResponse response) {
        this.wrappedRequest = new ServletEnvironmentRequest(request);
        this.externalContext.updateOnReload(this.wrappedRequest, response);
    }

    public void makeCurrent() {
        this.externalContext.injectBundles(this.bundles);
        this.persistentFacesState.setCurrentInstance();
        this.facesContext.setCurrentInstance();
        this.facesContext.applyBrowserDOMChanges();
    }

    private void notifyViewCreation() {
        Iterator i = this.viewListeners.iterator();
        while (i.hasNext()) {
            try {
                ViewListener listener = (ViewListener)i.next();
                listener.viewCreated();
            }
            catch (Throwable t) {
                Log.warn((Object)"Failed to invoke view listener", t);
            }
        }
    }

    private void notifyViewDisposal() {
        Iterator i = this.viewListeners.iterator();
        while (i.hasNext()) {
            try {
                ViewListener listener = (ViewListener)i.next();
                listener.viewDisposed();
            }
            catch (Throwable t) {
                Log.warn((Object)"Failed to invoke view listener", t);
            }
        }
    }
}

