/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.application.D2DViewHandler;
import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.servlet.FileUploadComponent;
import com.icesoft.faces.webapp.http.servlet.PseudoServlet;
import com.icesoft.faces.webapp.http.servlet.ServletView;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UploadServlet
implements PseudoServlet {
    private static final Log Log = LogFactory.getLog((Class)UploadServlet.class);
    private Map views;
    private long maxSize;
    private String uploadDirectory;
    private boolean uploadDirectoryAbsolute;
    private ServletContext servletContext;

    public UploadServlet(Map views, Configuration configuration, ServletContext servletContext) {
        this.views = views;
        this.maxSize = configuration.getAttributeAsLong("uploadMaxFileSize", 0x300000L);
        this.uploadDirectory = configuration.getAttribute("uploadDirectory", "");
        this.uploadDirectoryAbsolute = configuration.getAttributeAsBoolean("uploadDirectoryAbsolute", false);
        this.servletContext = servletContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServletFileUpload uploader = new ServletFileUpload();
        final ProgressCalculator progressCalculator = new ProgressCalculator();
        uploader.setFileSizeMax(this.maxSize);
        uploader.setProgressListener(new ProgressListener(){

            public void update(long read, long total, int chunkIndex) {
                progressCalculator.progress(read, total);
            }
        });
        FileItemIterator iter = uploader.getItemIterator(request);
        String viewIdentifier = null;
        String componentID = null;
        while (iter.hasNext()) {
            FileItemStream item = iter.next();
            if (item.isFormField()) {
                String name = item.getFieldName();
                if ("componentID".equals(name)) {
                    componentID = Streams.asString((InputStream)item.openStream());
                    continue;
                }
                if (!"viewNumber".equals(name)) continue;
                viewIdentifier = Streams.asString((InputStream)item.openStream());
                continue;
            }
            ServletView view = (ServletView)this.views.get(viewIdentifier);
            BridgeFacesContext context = view.getFacesContext();
            FileUploadComponent component = (FileUploadComponent)D2DViewHandler.findComponent(componentID, (UIComponent)context.getViewRoot());
            progressCalculator.setListenerAndContext(component, context);
            try {
                view.makeCurrent();
                component.upload(item, this.uploadDirectory, this.uploadDirectoryAbsolute, this.maxSize, context, this.servletContext, request.getRequestedSessionId());
            }
            catch (IOException e) {
                try {
                    progressCalculator.reset();
                }
                catch (Throwable tr) {
                    // empty catch block
                }
            }
            catch (Throwable t) {
                try {
                    progressCalculator.reset();
                }
                catch (Throwable tr) {
                    // empty catch block
                }
                Log.warn((Object)"File upload failed", t);
            }
            finally {
                response.setContentType("text/html");
                response.setHeader("Connection", "close");
                component.renderIFrame(response.getWriter(), context);
            }
        }
    }

    public void shutdown() {
    }

    private static class ProgressCalculator {
        private final int GRANULARITY = 10;
        private FileUploadComponent listener;
        private BridgeFacesContext context;
        private int lastGranularlyNotifiablePercent = -1;

        private ProgressCalculator() {
        }

        public void progress(long read, long total) {
            if (total > 0L) {
                int percentage = (int)(read * 100L / total);
                int percentageAboveGranularity = percentage % 10;
                int granularNotifiablePercentage = percentage - percentageAboveGranularity;
                boolean shouldNotify = granularNotifiablePercentage > this.lastGranularlyNotifiablePercent;
                this.lastGranularlyNotifiablePercent = granularNotifiablePercentage;
                if (shouldNotify) {
                    this.potentiallyNotify();
                }
            }
        }

        public void setListenerAndContext(FileUploadComponent listener, BridgeFacesContext context) {
            this.listener = listener;
            this.context = context;
            this.potentiallyNotify();
        }

        public void reset() {
            BridgeFacesContext ctx = this.context;
            FileUploadComponent component = this.listener;
            this.context = null;
            this.listener = null;
            if (ctx != null && component != null) {
                ctx.setCurrentInstance();
                component.setProgress(0);
            }
        }

        protected void potentiallyNotify() {
            if (this.listener != null && this.lastGranularlyNotifiablePercent >= 0) {
                this.context.setCurrentInstance();
                this.listener.setProgress(this.lastGranularlyNotifiablePercent);
            }
        }
    }
}

