/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.xmlhttp;

import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.context.ViewListener;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.parser.ImplementationUtil;
import com.icesoft.faces.webapp.xmlhttp.FatalRenderingException;
import com.icesoft.faces.webapp.xmlhttp.RenderingException;
import com.icesoft.faces.webapp.xmlhttp.TransientRenderingException;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PersistentFacesState
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)PersistentFacesState.class);
    private static ExecutorService executorService = Executors.newSingleThreadExecutor();
    private static InheritableThreadLocal localInstance = new InheritableThreadLocal();
    private BridgeFacesContext facesContext;
    private Lifecycle lifecycle;
    private ClassLoader renderableClassLoader = Thread.currentThread().getContextClassLoader();
    private boolean synchronousMode;
    private Collection viewListeners;

    public PersistentFacesState(BridgeFacesContext facesContext, Collection viewListeners, Configuration configuration) {
        this.facesContext = facesContext;
        this.viewListeners = viewListeners;
        this.synchronousMode = configuration.getAttributeAsBoolean("synchronousUpdate", false);
        LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        this.lifecycle = factory.getLifecycle("DEFAULT");
        this.setCurrentInstance();
    }

    public void setCurrentInstance() {
        localInstance.set(this);
    }

    public static PersistentFacesState getInstance() {
        return (PersistentFacesState)localInstance.get();
    }

    public static PersistentFacesState getInstance(Map sessionMap) {
        return PersistentFacesState.getInstance();
    }

    public FacesContext getFacesContext() {
        return this.facesContext;
    }

    public void setFacesContext(BridgeFacesContext facesContext) {
        this.facesContext = facesContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render() throws RenderingException {
        this.warn();
        this.facesContext.setCurrentInstance();
        this.facesContext.setFocusId("");
        BridgeFacesContext bridgeFacesContext = this.facesContext;
        synchronized (bridgeFacesContext) {
            try {
                this.lifecycle.render((FacesContext)this.facesContext);
                this.facesContext.release();
            }
            catch (IllegalStateException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("fatal render failure for viewNumber " + this.facesContext.getViewNumber()), (Throwable)e);
                }
                throw new FatalRenderingException("fatal render failure for viewNumber " + this.facesContext.getViewNumber(), e);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("transient render failure for viewNumber " + this.facesContext.getViewNumber()), (Throwable)e);
                }
                throw new TransientRenderingException("transient render failure for viewNumber " + this.facesContext.getViewNumber(), e);
            }
        }
    }

    public void renderLater() {
        this.warn();
        executorService.execute((Runnable)new RenderRunner());
    }

    public void renderLater(long miliseconds) {
        this.warn();
        executorService.execute((Runnable)new RenderRunner(miliseconds));
    }

    public void redirectTo(String uri) {
        this.warn();
        try {
            this.facesContext.setCurrentInstance();
            ExternalContext externalContext = this.facesContext.getExternalContext();
            externalContext.redirect(uri);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void navigateTo(String outcome) {
        this.warn();
        try {
            this.facesContext.setCurrentInstance();
            this.facesContext.getApplication().getNavigationHandler().handleNavigation((FacesContext)this.facesContext, this.facesContext.getViewRoot().getViewId(), outcome);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void release() {
        localInstance.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws RenderingException {
        this.facesContext.setCurrentInstance();
        BridgeFacesContext bridgeFacesContext = this.facesContext;
        synchronized (bridgeFacesContext) {
            try {
                if (ImplementationUtil.isJSF12()) {
                    this.facesContext.getExternalContext().getRequestParameterMap().clear();
                } else {
                    this.facesContext.renderResponse();
                }
                this.lifecycle.execute((FacesContext)this.facesContext);
            }
            catch (IllegalStateException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("fatal render failure for viewNumber " + this.facesContext.getViewNumber()), (Throwable)e);
                }
                throw new FatalRenderingException("fatal render failure for viewNumber " + this.facesContext.getViewNumber(), e);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("transient render failure for viewNumber " + this.facesContext.getViewNumber()), (Throwable)e);
                }
                throw new TransientRenderingException("transient render failure for viewNumber " + this.facesContext.getViewNumber(), e);
            }
        }
    }

    public ClassLoader getRenderableClassLoader() {
        return this.renderableClassLoader;
    }

    public void addViewListener(ViewListener listener) {
        this.viewListeners.add(listener);
    }

    private void warn() {
        if (this.synchronousMode) {
            log.warn((Object)"Running in 'synchronous mode'. The page updates were queued but not sent.");
        }
    }

    private class RenderRunner
    implements Runnable {
        private long delay = 0L;

        public RenderRunner() {
        }

        public RenderRunner(long miliseconds) {
            this.delay = miliseconds;
        }

        public void run() {
            try {
                Thread.sleep(this.delay);
                PersistentFacesState.this.execute();
                PersistentFacesState.this.render();
            }
            catch (RenderingException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"renderLater failed ", (Throwable)e);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

