/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utilities {
    private static final String[] spaces = new String[21];
    private static final int PRIME_NUMBER = 37;
    private static final Queue EMPTY_QUEUE;

    private Utilities() {
    }

    public static boolean equals(boolean o1, boolean o2) {
        return o1 == o2;
    }

    public static boolean equals(char o1, char o2) {
        return o1 == o2;
    }

    public static boolean equals(byte o1, byte o2) {
        return o1 == o2;
    }

    public static boolean equals(short o1, short o2) {
        return o1 == o2;
    }

    public static boolean equals(int o1, int o2) {
        return o1 == o2;
    }

    public static boolean equals(long o1, long o2) {
        return o1 == o2;
    }

    public static boolean equals(float o1, float o2) {
        return Float.floatToIntBits(o1) == Float.floatToIntBits(o2);
    }

    public static boolean equals(double o1, double o2) {
        return Double.doubleToLongBits(o1) == Double.doubleToLongBits(o2);
    }

    public static boolean equals(Object object1, Object object2) throws AssertionError {
        assert (object1 == null || !object1.getClass().isArray()) : object1;
        assert (object2 == null || !object2.getClass().isArray()) : object2;
        return object1 == object2 || object1 != null && object1.equals(object2);
    }

    public static boolean deepEquals(Object object1, Object object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        if (object1 instanceof Object[]) {
            return object2 instanceof Object[] && Arrays.deepEquals((Object[])object1, (Object[])object2);
        }
        if (object1 instanceof double[]) {
            return object2 instanceof double[] && Arrays.equals((double[])object1, (double[])object2);
        }
        if (object1 instanceof float[]) {
            return object2 instanceof float[] && Arrays.equals((float[])object1, (float[])object2);
        }
        if (object1 instanceof long[]) {
            return object2 instanceof long[] && Arrays.equals((long[])object1, (long[])object2);
        }
        if (object1 instanceof int[]) {
            return object2 instanceof int[] && Arrays.equals((int[])object1, (int[])object2);
        }
        if (object1 instanceof short[]) {
            return object2 instanceof short[] && Arrays.equals((short[])object1, (short[])object2);
        }
        if (object1 instanceof byte[]) {
            return object2 instanceof byte[] && Arrays.equals((byte[])object1, (byte[])object2);
        }
        if (object1 instanceof char[]) {
            return object2 instanceof char[] && Arrays.equals((char[])object1, (char[])object2);
        }
        if (object1 instanceof boolean[]) {
            return object2 instanceof boolean[] && Arrays.equals((boolean[])object1, (boolean[])object2);
        }
        return object1.equals(object2);
    }

    public static int hash(boolean value, int seed) {
        return seed * 37 + (value ? 1231 : 1237);
    }

    public static int hash(char value, int seed) {
        return seed * 37 + value;
    }

    public static int hash(int value, int seed) {
        return seed * 37 + value;
    }

    public static int hash(long value, int seed) {
        return seed * 37 + ((int)value ^ (int)(value >>> 32));
    }

    public static int hash(float value, int seed) {
        return seed * 37 + Float.floatToIntBits(value);
    }

    public static int hash(double value, int seed) {
        return Utilities.hash(Double.doubleToLongBits(value), seed);
    }

    public static int hash(Object value, int seed) throws AssertionError {
        seed *= 37;
        if (value != null) {
            assert (!value.getClass().isArray()) : value;
            seed += value.hashCode();
        }
        return seed;
    }

    public static int deepHashCode(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Object[]) {
            return Arrays.deepHashCode((Object[])object);
        }
        if (object instanceof double[]) {
            return Arrays.hashCode((double[])object);
        }
        if (object instanceof float[]) {
            return Arrays.hashCode((float[])object);
        }
        if (object instanceof long[]) {
            return Arrays.hashCode((long[])object);
        }
        if (object instanceof int[]) {
            return Arrays.hashCode((int[])object);
        }
        if (object instanceof short[]) {
            return Arrays.hashCode((short[])object);
        }
        if (object instanceof byte[]) {
            return Arrays.hashCode((byte[])object);
        }
        if (object instanceof char[]) {
            return Arrays.hashCode((char[])object);
        }
        if (object instanceof boolean[]) {
            return Arrays.hashCode((boolean[])object);
        }
        return object.hashCode();
    }

    public static String deepToString(Object object) {
        if (object instanceof Object[]) {
            return Arrays.deepToString((Object[])object);
        }
        if (object instanceof double[]) {
            return Arrays.toString((double[])object);
        }
        if (object instanceof float[]) {
            return Arrays.toString((float[])object);
        }
        if (object instanceof long[]) {
            return Arrays.toString((long[])object);
        }
        if (object instanceof int[]) {
            return Arrays.toString((int[])object);
        }
        if (object instanceof short[]) {
            return Arrays.toString((short[])object);
        }
        if (object instanceof byte[]) {
            return Arrays.toString((byte[])object);
        }
        if (object instanceof char[]) {
            return Arrays.toString((char[])object);
        }
        if (object instanceof boolean[]) {
            return Arrays.toString((boolean[])object);
        }
        return String.valueOf(object);
    }

    public static <E> Queue<E> emptyQueue() {
        return EMPTY_QUEUE;
    }

    public static String spaces(int length) {
        String s;
        if (length < 0) {
            length = 0;
        }
        if (length < spaces.length) {
            s = spaces[length];
            if (s == null) {
                Utilities.spaces[length] = s = spaces[spaces.length - 1].substring(0, length).intern();
            }
        } else {
            char[] blancs = new char[length];
            Arrays.fill(blancs, ' ');
            s = new String(blancs);
        }
        return s;
    }

    static {
        int last = spaces.length - 1;
        char[] blancs = new char[last];
        Arrays.fill(blancs, ' ');
        Utilities.spaces[last] = new String(blancs).intern();
        EMPTY_QUEUE = new EmptyQueue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmptyQueue<E>
    extends AbstractQueue<E>
    implements Serializable {
        private static final long serialVersionUID = -6147951199761870325L;

        private EmptyQueue() {
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<E> iterator() {
            Set empty = Collections.emptySet();
            return empty.iterator();
        }

        @Override
        public boolean offer(E e) {
            return false;
        }

        @Override
        public E poll() {
            return null;
        }

        @Override
        public E peek() {
            return null;
        }

        protected Object readResolve() throws ObjectStreamException {
            return EMPTY_QUEUE;
        }
    }
}

