/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.audit;

import com.liferay.portal.kernel.audit.AuditRequestThreadLocal;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;

public class AuditMessage
implements Serializable {
    private static final String _ADDITIONAL_INFO = "additionalInfo";
    private static final String _CLASS_NAME = "className";
    private static final String _CLASS_PK = "classPK";
    private static final String _CLIENT_HOST = "clientHost";
    private static final String _CLIENT_IP = "clientIP";
    private static final String _COMPANY_ID = "companyId";
    private static final String _DATE_FORMAT = "yyyyMMddkkmmssSSS";
    private static final String _EVENT_TYPE = "eventType";
    private static final String _MESSAGE = "message";
    private static final String _SERVER_NAME = "serverName";
    private static final String _SERVER_PORT = "serverPort";
    private static final String _SESSION_ID = "sessionID";
    private static final String _TIMESTAMP = "timestamp";
    private static final String _USER_ID = "userId";
    private static final String _USER_NAME = "userName";
    private JSONObject _additionalInfo;
    private String _className;
    private String _classPK;
    private String _clientHost;
    private String _clientIP;
    private long _companyId = -1L;
    private String _eventType;
    private String _message;
    private String _serverName;
    private int _serverPort;
    private String _sessionID;
    private Date _timestamp;
    private long _userId = -1L;
    private String _userName;

    public AuditMessage(String message) throws JSONException {
        JSONObject jsonObj = JSONFactoryUtil.createJSONObject(message);
        this._eventType = jsonObj.getString(_EVENT_TYPE);
        this._companyId = jsonObj.getLong(_COMPANY_ID);
        this._userId = jsonObj.getLong(_USER_ID);
        this._userName = jsonObj.getString(_USER_NAME);
        this._className = jsonObj.getString(_CLASS_NAME);
        this._classPK = jsonObj.getString(_CLASS_PK);
        this._message = jsonObj.getString(_MESSAGE);
        if (jsonObj.has(_CLIENT_HOST)) {
            this._clientHost = jsonObj.getString(_CLIENT_HOST);
        }
        if (jsonObj.has(_CLIENT_IP)) {
            this._clientIP = jsonObj.getString(_CLIENT_IP);
        }
        if (jsonObj.has(_SERVER_NAME)) {
            this._serverName = jsonObj.getString(_SERVER_NAME);
        }
        if (jsonObj.has(_SERVER_PORT)) {
            this._serverPort = jsonObj.getInt(_SERVER_PORT);
        }
        if (jsonObj.has(_SESSION_ID)) {
            this._sessionID = jsonObj.getString(_SESSION_ID);
        }
        this._timestamp = GetterUtil.getDate(jsonObj.getString(_TIMESTAMP), this._getDateFormat());
        this._additionalInfo = jsonObj.getJSONObject(_ADDITIONAL_INFO);
    }

    public AuditMessage(String eventType, long companyId, long userId, String userName) {
        this(eventType, companyId, userId, userName, null, null, null, new Date(), JSONFactoryUtil.createJSONObject());
    }

    public AuditMessage(String eventType, long companyId, long userId, String userName, String className, String classPK, String message) {
        this(eventType, companyId, userId, userName, className, classPK, message, new Date(), JSONFactoryUtil.createJSONObject());
    }

    public AuditMessage(String eventType, long companyId, long userId, String userName, String className, String classPK, String message, Date timestamp, JSONObject additionalInfo) {
        this._eventType = eventType;
        this._companyId = companyId;
        this._userId = userId;
        this._userName = userName;
        this._className = className;
        this._classPK = classPK;
        this._message = message;
        AuditRequestThreadLocal auditRequestThreadLocal = AuditRequestThreadLocal.getAuditThreadLocal();
        this._clientHost = auditRequestThreadLocal.getClientHost();
        this._clientIP = auditRequestThreadLocal.getClientIP();
        this._serverName = auditRequestThreadLocal.getServerName();
        this._serverPort = auditRequestThreadLocal.getServerPort();
        this._sessionID = auditRequestThreadLocal.getSessionID();
        this._timestamp = timestamp;
        this._additionalInfo = additionalInfo;
    }

    public AuditMessage(String eventType, long companyId, long userId, String userName, String className, String classPK, String message, JSONObject additionalInfo) {
        this(eventType, companyId, userId, userName, className, classPK, message, new Date(), additionalInfo);
    }

    public JSONObject getAdditionalInfo() {
        return this._additionalInfo;
    }

    public String getClassName() {
        return this._className;
    }

    public String getClassPK() {
        return this._classPK;
    }

    public String getClientHost() {
        return this._clientHost;
    }

    public String getClientIP() {
        return this._clientIP;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public String getEventType() {
        return this._eventType;
    }

    public String getMessage() {
        return this._message;
    }

    public String getServerName() {
        return this._serverName;
    }

    public int getServerPort() {
        return this._serverPort;
    }

    public String getSessionID() {
        return this._sessionID;
    }

    public Date getTimestamp() {
        return this._timestamp;
    }

    public long getUserId() {
        return this._userId;
    }

    public String getUserName() {
        return this._userName;
    }

    public void setAdditionalInfo(JSONObject additionalInfo) {
        this._additionalInfo = additionalInfo;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setClassPK(String classPK) {
        this._classPK = classPK;
    }

    public void setClientHost(String clientHost) {
        this._clientHost = clientHost;
    }

    public void setClientIP(String clientIP) {
        this._clientIP = clientIP;
    }

    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    public void setEventType(String eventType) {
        this._eventType = eventType;
    }

    public void setMessage(String message) {
        this._message = message;
    }

    public void setServerName(String serverName) {
        this._serverName = serverName;
    }

    public void setServerPort(int serverPort) {
        this._serverPort = serverPort;
    }

    public void setSessionID(String sessionID) {
        this._sessionID = sessionID;
    }

    public void setTimestamp(Date timestamp) {
        this._timestamp = timestamp;
    }

    public void setUserId(long userId) {
        this._userId = userId;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    public JSONObject toJSONObject() {
        JSONObject jsonObj = JSONFactoryUtil.createJSONObject();
        jsonObj.put(_ADDITIONAL_INFO, this._additionalInfo);
        jsonObj.put(_COMPANY_ID, this._companyId);
        jsonObj.put(_CLASS_PK, this._classPK);
        jsonObj.put(_CLASS_NAME, this._className);
        jsonObj.put(_CLIENT_IP, this._clientIP);
        jsonObj.put(this._clientHost, this._clientHost);
        jsonObj.put(_MESSAGE, this._message);
        jsonObj.put(_SERVER_PORT, this._serverPort);
        jsonObj.put(_SERVER_NAME, this._serverName);
        jsonObj.put(_SESSION_ID, this._sessionID);
        jsonObj.put(_TIMESTAMP, this._getDateFormat().format(new Date()));
        jsonObj.put(_EVENT_TYPE, this._eventType);
        jsonObj.put(_USER_ID, this._userId);
        jsonObj.put(_USER_NAME, this._userName);
        return jsonObj;
    }

    private DateFormat _getDateFormat() {
        return DateFormatFactoryUtil.getSimpleDateFormat(_DATE_FORMAT);
    }
}

