/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.bean;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ContextClassLoaderBeanHandler
implements InvocationHandler {
    private Object _bean;
    private ClassLoader _classLoader;

    public ContextClassLoaderBeanHandler(Object bean, ClassLoader classLoader) {
        this._bean = bean;
        this._classLoader = classLoader;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (this._classLoader != null && contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(this._classLoader);
            }
            Object object = method.invoke(this._bean, args);
            return object;
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
        finally {
            if (this._classLoader != null && contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }
}

