/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.bean;

import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

public class PortalBeanLocatorUtil {
    private static Log _log = LogFactoryUtil.getLog(PortalBeanLocatorUtil.class);
    private static BeanLocator _beanLocator;

    public static BeanLocator getBeanLocator() {
        return _beanLocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object locate(String name) throws BeanLocatorException {
        if (_beanLocator == null) {
            _log.error("BeanLocator is null");
            throw new BeanLocatorException("BeanLocator has not been set");
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        ClassLoader beanClassLoader = _beanLocator.getClassLoader();
        try {
            if (contextClassLoader != beanClassLoader) {
                currentThread.setContextClassLoader(beanClassLoader);
            }
            Object object = _beanLocator.locate(name);
            return object;
        }
        finally {
            if (contextClassLoader != beanClassLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    public static void setBeanLocator(BeanLocator beanLocator) {
        if (_log.isDebugEnabled()) {
            _log.debug("Setting BeanLocator " + beanLocator.hashCode());
        }
        _beanLocator = beanLocator;
    }
}

