/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.bi.reporting;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ReportDataSourceType {
    CSV("csv"),
    EMPTY("empty"),
    JDBC("jdbc"),
    PORTAL("portal"),
    XLS("xls"),
    XML("xml");

    private static final Map<String, ReportDataSourceType> _reportDataSourceTypes;
    private String _value;

    public static ReportDataSourceType parse(String value) {
        ReportDataSourceType reportDataSourceType = _reportDataSourceTypes.get(value);
        if (reportDataSourceType != null) {
            return reportDataSourceType;
        }
        if (CSV.toString().equalsIgnoreCase(value)) {
            return CSV;
        }
        if (EMPTY.toString().equalsIgnoreCase(value)) {
            return EMPTY;
        }
        if (JDBC.toString().equalsIgnoreCase(value)) {
            return JDBC;
        }
        if (PORTAL.toString().equalsIgnoreCase(value)) {
            return PORTAL;
        }
        if (XLS.toString().equalsIgnoreCase(value)) {
            return XLS;
        }
        if (XML.toString().equalsIgnoreCase(value)) {
            return XML;
        }
        throw new IllegalArgumentException("Invalid data source type " + value);
    }

    public String toString() {
        return this._value;
    }

    private ReportDataSourceType(String value) {
        this._value = value;
    }

    static {
        _reportDataSourceTypes = new HashMap<String, ReportDataSourceType>();
        _reportDataSourceTypes.put(CSV.toString(), CSV);
        _reportDataSourceTypes.put(EMPTY.toString(), EMPTY);
        _reportDataSourceTypes.put(JDBC.toString(), JDBC);
        _reportDataSourceTypes.put(PORTAL.toString(), PORTAL);
        _reportDataSourceTypes.put(XLS.toString(), XLS);
        _reportDataSourceTypes.put(XML.toString(), XML);
    }
}

