/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.bi.reporting.messaging;

import com.liferay.portal.kernel.bi.reporting.ReportDesignRetriever;
import com.liferay.portal.kernel.bi.reporting.ReportEngine;
import com.liferay.portal.kernel.bi.reporting.ReportGenerationException;
import com.liferay.portal.kernel.bi.reporting.ReportRequest;
import com.liferay.portal.kernel.bi.reporting.ReportResultContainer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;

public class ReportCompilerRequestMessageListener
implements MessageListener {
    private static final Log _log = LogFactoryUtil.getLog(ReportCompilerRequestMessageListener.class);
    private ReportEngine _reportEngine;
    private ReportResultContainer _reportResultContainer;

    public ReportCompilerRequestMessageListener(ReportEngine reportEngine, ReportResultContainer reportResultContainer) {
        this._reportEngine = reportEngine;
        this._reportResultContainer = reportResultContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Message message) {
        ReportRequest reportRequest = (ReportRequest)message.getPayload();
        ReportDesignRetriever reportDesignRetriever = reportRequest.getReportDesignRetriever();
        ReportResultContainer reportResultContainer = this._reportResultContainer.clone(reportDesignRetriever.getReportName());
        try {
            this._reportEngine.compile(reportRequest);
        }
        catch (ReportGenerationException rge) {
            _log.error("Unable to compile report", rge);
            reportResultContainer.setReportGenerationException(rge);
        }
        finally {
            Message responseMessage = MessageBusUtil.createResponseMessage(message, reportResultContainer);
            responseMessage.setPayload(reportResultContainer);
            MessageBusUtil.sendMessage(responseMessage.getDestinationName(), responseMessage);
        }
    }
}

