/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cache;

import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CacheRegistry {
    private static Log _log = LogFactoryUtil.getLog(CacheRegistry.class);
    private static boolean _active = true;
    private static Map<String, CacheRegistryItem> _items = new ConcurrentHashMap<String, CacheRegistryItem>();

    public static void clear() {
        for (Map.Entry<String, CacheRegistryItem> entry : _items.entrySet()) {
            CacheRegistryItem item = entry.getValue();
            if (_log.isDebugEnabled()) {
                _log.debug("Invalidating " + item.getRegistryName());
            }
            item.invalidate();
        }
    }

    public static void clear(String name) {
        CacheRegistryItem item = _items.get(name);
        if (item != null) {
            if (_log.isDebugEnabled()) {
                _log.debug("Invalidating " + name);
            }
            item.invalidate();
        } else {
            _log.error("No cache registry found with name " + name);
        }
    }

    public static boolean isActive() {
        return _active;
    }

    public static void register(CacheRegistryItem item) {
        String name = item.getRegistryName();
        if (_log.isDebugEnabled()) {
            _log.debug("Registering " + name);
        }
        if (_items.containsKey(name)) {
            if (_log.isDebugEnabled()) {
                _log.debug("Not registering duplicate " + name);
            }
        } else {
            _items.put(name, item);
        }
    }

    public static void setActive(boolean active) {
        _active = active;
        if (!active) {
            CacheRegistry.clear();
        }
    }

    public static void unregister(String name) {
        if (_log.isDebugEnabled()) {
            _log.debug("Unregistering " + name);
        }
        _items.remove(name);
    }
}

