/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.deploy.auto;

import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.AutoDeployListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;

public abstract class BaseAutoDeployListener
implements AutoDeployListener {
    private static Log _log = LogFactoryUtil.getLog(BaseAutoDeployListener.class);

    public boolean isExtPlugin(File file) {
        return file.getName().contains("-ext");
    }

    public boolean isHookPlugin(File file) throws AutoDeployException {
        return this.isMatchingFile(file, "WEB-INF/liferay-plugin-package.properties") && file.getName().contains("-hook") && !file.getName().contains("-portlet");
    }

    public boolean isMatchingFile(File file, String checkXmlFile) throws AutoDeployException {
        if (!this.isMatchingFileExtension(file)) {
            return false;
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            if (zipFile.getEntry(checkXmlFile) == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug(file.getPath() + " does not have " + checkXmlFile);
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            throw new AutoDeployException(ioe);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public boolean isMatchingFileExtension(File file) {
        String fileName = file.getName().toLowerCase();
        if (fileName.endsWith(".war") || fileName.endsWith(".zip")) {
            if (_log.isDebugEnabled()) {
                _log.debug(file.getPath() + " has a matching extension");
            }
            return true;
        }
        if (_log.isDebugEnabled()) {
            _log.debug(file.getPath() + " does not have a matching extension");
        }
        return false;
    }

    public boolean isThemePlugin(File file) throws AutoDeployException {
        if (this.isMatchingFile(file, "WEB-INF/liferay-look-and-feel.xml")) {
            return true;
        }
        return this.isMatchingFile(file, "WEB-INF/liferay-plugin-package.properties") && file.getName().contains("-theme");
    }

    public boolean isWebPlugin(File file) throws AutoDeployException {
        return this.isMatchingFile(file, "WEB-INF/liferay-plugin-package.properties") && file.getName().contains("-web");
    }
}

