/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.deploy.hot;

import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.deploy.hot.HotDeployListener;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.servlet.ServletContextUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;

public abstract class BaseHotDeployListener
implements HotDeployListener {
    public void throwHotDeployException(HotDeployEvent event, String msg, Throwable t) throws HotDeployException {
        ServletContext servletContext = event.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        throw new HotDeployException(msg + servletContextName, t);
    }

    protected void registerClpMessageListeners(ServletContext servletContext, ClassLoader portletClassLoader) throws Exception {
        ArrayList<MessageListener> clpMessageListeners = (ArrayList<MessageListener>)servletContext.getAttribute("CLP_MESSAGE_LISTENERS");
        if (clpMessageListeners != null) {
            return;
        }
        clpMessageListeners = new ArrayList<MessageListener>();
        Set<String> classNames = ServletContextUtil.getClassNames(servletContext);
        for (String className : classNames) {
            if (!className.endsWith(".ClpMessageListener")) continue;
            Class<?> clpMessageListenerClass = portletClassLoader.loadClass(className);
            MessageListener clpMessageListener = (MessageListener)clpMessageListenerClass.newInstance();
            Field servletContextNameField = clpMessageListenerClass.getField("SERVLET_CONTEXT_NAME");
            String clpServletContextName = servletContextNameField.get(clpMessageListener).toString();
            if (clpServletContextName.equals(servletContext.getServletContextName())) continue;
            clpMessageListeners.add(clpMessageListener);
            MessageBusUtil.registerMessageListener("liferay/hot_deploy", clpMessageListener);
        }
        servletContext.setAttribute("CLP_MESSAGE_LISTENERS", clpMessageListeners);
    }

    protected void unregisterClpMessageListeners(ServletContext servletContext) throws Exception {
        List clpMessageListeners = (List)servletContext.getAttribute("CLP_MESSAGE_LISTENERS");
        if (clpMessageListeners != null) {
            servletContext.removeAttribute("CLP_MESSAGE_LISTENERS");
            for (MessageListener clpMessageListener : clpMessageListeners) {
                MessageBusUtil.unregisterMessageListener("liferay/hot_deploy", clpMessageListener);
            }
        }
    }
}

