/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io.unsync;

import com.liferay.portal.kernel.util.StringBundler;
import java.io.IOException;
import java.io.Reader;

public class UnsyncBufferedReader
extends Reader {
    protected char[] buffer;
    protected int firstInvalidIndex;
    protected int index;
    protected int markIndex = -1;
    protected int markLimit;
    protected Reader reader;
    private static int _DEFAULT_BUFFER_SIZE = 8192;
    private static int _MAX_MARK_WASTE_SIZE = 4096;

    public UnsyncBufferedReader(Reader reader) {
        this(reader, _DEFAULT_BUFFER_SIZE);
    }

    public UnsyncBufferedReader(Reader reader, int size) {
        this.reader = reader;
        this.buffer = new char[size];
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        this.buffer = null;
    }

    public void mark(int markLimit) throws IOException {
        if (this.reader == null) {
            throw new IOException("Reader is null");
        }
        this.markLimit = markLimit;
        this.markIndex = this.index;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        if (this.reader == null) {
            throw new IOException("Reader is null");
        }
        if (this.index >= this.firstInvalidIndex) {
            this.readUnderlyingReader();
            if (this.index >= this.firstInvalidIndex) {
                return -1;
            }
        }
        return this.buffer[this.index++];
    }

    public int read(char[] charArray) throws IOException {
        return this.read(charArray, 0, charArray.length);
    }

    public int read(char[] charArray, int offset, int length) throws IOException {
        if (this.reader == null) {
            throw new IOException("Reader is null");
        }
        if (length <= 0) {
            return 0;
        }
        int read = 0;
        while (true) {
            int available;
            if ((available = this.firstInvalidIndex - this.index) + read >= length) {
                int leftSize = length - read;
                System.arraycopy(this.buffer, this.index, charArray, read, leftSize);
                this.index += leftSize;
                return length;
            }
            if (available <= 0) {
                this.readUnderlyingReader();
                available = this.firstInvalidIndex - this.index;
                if (available > 0) continue;
                if (read == 0) {
                    return -1;
                }
                return read;
            }
            System.arraycopy(this.buffer, this.index, charArray, read, available);
            this.index += available;
            read += available;
        }
    }

    public String readLine() throws IOException {
        if (this.reader == null) {
            throw new IOException("Reader is null");
        }
        StringBundler sb = null;
        while (true) {
            int y;
            if (this.index >= this.firstInvalidIndex) {
                this.readUnderlyingReader();
            }
            if (this.index >= this.firstInvalidIndex) {
                if (sb != null && sb.index() > 0) {
                    return sb.toString();
                }
                return null;
            }
            boolean hasLineBreak = false;
            char lineEndChar = '\u0000';
            int x = this.index;
            for (y = this.index; y < this.firstInvalidIndex; ++y) {
                lineEndChar = this.buffer[y];
                if (lineEndChar != '\n' && lineEndChar != '\r') continue;
                hasLineBreak = true;
                break;
            }
            String line = new String(this.buffer, x, y - x);
            this.index = y;
            if (hasLineBreak) {
                ++this.index;
                if (lineEndChar == '\r' && this.index < this.buffer.length && this.buffer[this.index] == '\n') {
                    ++this.index;
                }
                if (sb == null) {
                    return line;
                }
                sb.append(line);
                return sb.toString();
            }
            if (sb == null) {
                sb = new StringBundler();
            }
            sb.append(line);
        }
    }

    public boolean ready() throws IOException {
        if (this.reader == null) {
            throw new IOException("Reader is null");
        }
        return this.index < this.firstInvalidIndex || this.reader.ready();
    }

    public void reset() throws IOException {
        if (this.reader == null) {
            throw new IOException("Reader is null");
        }
        if (this.markIndex < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.index = this.markIndex;
    }

    public long skip(long skip) throws IOException {
        if (this.reader == null) {
            throw new IOException("Reader is null");
        }
        if (skip <= 0L) {
            return 0L;
        }
        long available = this.firstInvalidIndex - this.index;
        if (available > 0L) {
            if (available < skip) {
                skip = available;
            }
        } else if (this.markIndex < 0) {
            skip = this.reader.skip(skip);
        } else {
            this.readUnderlyingReader();
            available = this.firstInvalidIndex - this.index;
            if (available > 0L && available < skip) {
                skip = available;
            }
        }
        this.index = (int)((long)this.index + skip);
        return skip;
    }

    protected void readUnderlyingReader() throws IOException {
        if (this.markIndex < 0) {
            this.firstInvalidIndex = 0;
            this.index = 0;
            int number = this.reader.read(this.buffer);
            if (number > 0) {
                this.firstInvalidIndex = number;
            }
            return;
        }
        if (this.index >= this.buffer.length) {
            if (this.firstInvalidIndex - this.markIndex > this.markLimit) {
                this.markIndex = -1;
                this.index = 0;
            } else if (this.markIndex > _MAX_MARK_WASTE_SIZE) {
                int realDataSize = this.index - this.markIndex;
                System.arraycopy(this.buffer, this.markIndex, this.buffer, 0, realDataSize);
                this.markIndex = 0;
                this.index = realDataSize;
            } else {
                int newBufferSize = this.index << 1;
                if (newBufferSize - _MAX_MARK_WASTE_SIZE > this.markLimit) {
                    newBufferSize = this.markLimit + _MAX_MARK_WASTE_SIZE;
                }
                char[] newBuffer = new char[newBufferSize];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.index);
                this.buffer = newBuffer;
            }
        }
        this.firstInvalidIndex = this.index;
        int number = this.reader.read(this.buffer, this.index, this.buffer.length - this.index);
        if (number > 0) {
            this.firstInvalidIndex += number;
        }
    }
}

